package com.st.stellar.model.lib

import java.io.BufferedReader
import java.io.BufferedWriter
import java.io.FileReader
import java.io.FileWriter
import java.io.IOException
import java.util.regex.Pattern
import java.util.Map
import com.st.stellar.model.lib.ModelMigration

class MigrationTov2_0_0 implements ModelMigration {

	static Map<String, String> FUNCTION_MAP = null

	def getNewFunctionName(String bitfieldStr) {
		if (FUNCTION_MAP === null) {
			FUNCTION_MAP = newHashMap
			FUNCTION_MAP.put("BDAC1_OUT", "BDAC_OUT1")
			FUNCTION_MAP.put("BDAC2_OUT", "BDAC_OUT2")
			FUNCTION_MAP.put("B_DAC1_OUT", "BDAC_OUT1")
			FUNCTION_MAP.put("B_DAC2_OUT", "BDAC_OUT2")
			FUNCTION_MAP.put("CAN1_RX_M_CAN_1_RX", "CAN1_RX")
			FUNCTION_MAP.put("CAN1_TX_M_CAN_1_TX", "CAN1_TX")
			FUNCTION_MAP.put("CAN2_RX_M_CAN_2_RX", "CAN2_RX")
			FUNCTION_MAP.put("CAN2_TX_M_CAN_2_TX", "CAN2_TX")
			FUNCTION_MAP.put("CAN3_RX_M_CAN_3_RX", "CAN3_RX")
			FUNCTION_MAP.put("CAN3_TX_M_CAN_3_TX", "CAN3_TX")
			FUNCTION_MAP.put("CAN4_RX_M_CAN_4_RX", "CAN4_RX")
			FUNCTION_MAP.put("CAN4_TX_M_CAN_4_TX", "CAN4_TX")
			FUNCTION_MAP.put("FCCU_EIN0_EIN_0", "FCCU_EIN0")
			FUNCTION_MAP.put("FCCU_EIN1_EIN_1", "FCCU_EIN1")
			FUNCTION_MAP.put("FCCU_EOUT0_EOUT_0", "FCCU_EOUT0")
			FUNCTION_MAP.put("FCCU_EOUT1_EOUT_1", "FCCU_EOUT1")
			FUNCTION_MAP.put("HRTIM1_CHA1_TA_1", "HRTIM1_CHA1")
			FUNCTION_MAP.put("HRTIM1_CHA2_TA_2", "HRTIM1_CHA2")
			FUNCTION_MAP.put("HRTIM1_CHB1_TB_1", "HRTIM1_CHB1")
			FUNCTION_MAP.put("HRTIM1_CHB2_TB_2", "HRTIM1_CHB2")
			FUNCTION_MAP.put("HRTIM1_CHC1_TC_1", "HRTIM1_CHC1")
			FUNCTION_MAP.put("HRTIM1_CHC2_TC_2", "HRTIM1_CHC2")
			FUNCTION_MAP.put("HRTIM1_CHD1_TD_1", "HRTIM1_CHD1")
			FUNCTION_MAP.put("HRTIM1_CHD2_TD_2", "HRTIM1_CHD2")
			FUNCTION_MAP.put("HRTIM1_CHE1_TE_1", "HRTIM1_CHE1")
			FUNCTION_MAP.put("HRTIM1_CHE2_TE_2", "HRTIM1_CHE2")
			FUNCTION_MAP.put("HRTIM1_CHF1_TF_1", "HRTIM1_CHF1")
			FUNCTION_MAP.put("HRTIM1_CHF2_TF_2", "HRTIM1_CHF2")
			FUNCTION_MAP.put("HRTIM1_EEV10_EEV10SRC", "HRTIM1_EEV10")
			FUNCTION_MAP.put("HRTIM1_EEV1_EEV1SRC", "HRTIM1_EEV1")
			FUNCTION_MAP.put("HRTIM1_EEV2_EEV2SRC", "HRTIM1_EEV2")
			FUNCTION_MAP.put("HRTIM1_EEV3_EEV3SRC", "HRTIM1_EEV3")
			FUNCTION_MAP.put("HRTIM1_EEV4_EEV4SRC", "HRTIM1_EEV4")
			FUNCTION_MAP.put("HRTIM1_EEV5_EEV5SRC", "HRTIM1_EEV5")
			FUNCTION_MAP.put("HRTIM1_EEV6_EEV6SRC", "HRTIM1_EEV6")
			FUNCTION_MAP.put("HRTIM1_EEV7_EEV7SRC", "HRTIM1_EEV7")
			FUNCTION_MAP.put("HRTIM1_EEV8_EEV8SRC", "HRTIM1_EEV8")
			FUNCTION_MAP.put("HRTIM1_EEV9_EEV9SRC", "HRTIM1_EEV9")
			FUNCTION_MAP.put("HRTIM1_FLT1_FLT_1", "HRTIM1_FLT1")
			FUNCTION_MAP.put("HRTIM1_FLT2_FLT_2", "HRTIM1_FLT2")
			FUNCTION_MAP.put("HRTIM1_FLT3_FLT_3", "HRTIM1_FLT3")
			FUNCTION_MAP.put("HRTIM1_FLT4_FLT_4", "HRTIM1_FLT4")
			FUNCTION_MAP.put("HRTIM1_FLT5_FLT_5", "HRTIM1_FLT5")
			FUNCTION_MAP.put("HRTIM1_FLT6_FLT_6", "HRTIM1_FLT6")
			FUNCTION_MAP.put("HRTIM1_SCIN_SYNCH_IN_3", "HRTIM1_SCIN")
			FUNCTION_MAP.put("HRTIM1_SCOUT_SYNCH_OUT_2", "HRTIM1_SCOUT")
			FUNCTION_MAP.put("HRTIM2_CHA1_TA_1", "HRTIM2_CHA1")
			FUNCTION_MAP.put("HRTIM2_CHA2_TA_2", "HRTIM2_CHA2")
			FUNCTION_MAP.put("HRTIM2_CHB1_TB_1", "HRTIM2_CHB1")
			FUNCTION_MAP.put("HRTIM2_CHB2_TB_2", "HRTIM2_CHB2")
			FUNCTION_MAP.put("HRTIM2_CHC1_TC_1", "HRTIM2_CHC1")
			FUNCTION_MAP.put("HRTIM2_CHC2_TC_2", "HRTIM2_CHC2")
			FUNCTION_MAP.put("HRTIM2_CHD1_TD_1", "HRTIM2_CHD1")
			FUNCTION_MAP.put("HRTIM2_CHD2_TD_2", "HRTIM2_CHD2")
			FUNCTION_MAP.put("HRTIM2_CHE1_TE_1", "HRTIM2_CHE1")
			FUNCTION_MAP.put("HRTIM2_CHE2_TE_2", "HRTIM2_CHE2")
			FUNCTION_MAP.put("HRTIM2_CHF1_TF_1", "HRTIM2_CHF1")
			FUNCTION_MAP.put("HRTIM2_CHF2_TF_2", "HRTIM2_CHF2")
			FUNCTION_MAP.put("HRTIM2_EEV10_EEV10SRC", "HRTIM2_EEV10")
			FUNCTION_MAP.put("HRTIM2_EEV1_EEV1SRC", "HRTIM2_EEV1")
			FUNCTION_MAP.put("HRTIM2_EEV2_EEV2SRC", "HRTIM2_EEV2")
			FUNCTION_MAP.put("HRTIM2_EEV3_EEV3SRC", "HRTIM2_EEV3")
			FUNCTION_MAP.put("HRTIM2_EEV4_EEV4SRC", "HRTIM2_EEV4")
			FUNCTION_MAP.put("HRTIM2_EEV5_EEV5SRC", "HRTIM2_EEV5")
			FUNCTION_MAP.put("HRTIM2_EEV6_EEV6SRC", "HRTIM2_EEV6")
			FUNCTION_MAP.put("HRTIM2_EEV7_EEV7SRC", "HRTIM2_EEV7")
			FUNCTION_MAP.put("HRTIM2_EEV8_EEV8SRC", "HRTIM2_EEV8")
			FUNCTION_MAP.put("HRTIM2_EEV9_EEV9SRC", "HRTIM2_EEV9")
			FUNCTION_MAP.put("HRTIM2_FLT1_FLT_1", "HRTIM2_FLT1")
			FUNCTION_MAP.put("HRTIM2_FLT2_FLT_2", "HRTIM2_FLT2")
			FUNCTION_MAP.put("HRTIM2_FLT3_FLT_3", "HRTIM2_FLT3")
			FUNCTION_MAP.put("HRTIM2_FLT4_FLT_4", "HRTIM2_FLT4")
			FUNCTION_MAP.put("HRTIM2_FLT5_FLT_5", "HRTIM2_FLT5")
			FUNCTION_MAP.put("HRTIM2_FLT6_FLT_6", "HRTIM2_FLT6")
			FUNCTION_MAP.put("HRTIM2_SCIN_SYNCH_IN_3", "")
			FUNCTION_MAP.put("I2C1_SCL_SCLIN", "I2C1_SCL")
			FUNCTION_MAP.put("I2C1_SCL_SCLOUT", "I2C1_SCL")
			FUNCTION_MAP.put("I2C1_SDA_SDAIN", "I2C1_SDA")
			FUNCTION_MAP.put("I2C1_SDA_SDAOUT", "I2C1_SDA")
			FUNCTION_MAP.put("I2C1_SMBA_SMBALERTIN", "I2C1_SMBA")
			FUNCTION_MAP.put("I2C1_SMBA_SMBALERTOUT", "I2C1_SMBA")
			FUNCTION_MAP.put("I2C2_SCL_SCLIN", "I2C2_SCL")
			FUNCTION_MAP.put("I2C2_SCL_SCLOUT", "I2C2_SCL")
			FUNCTION_MAP.put("I2C2_SDA_SDAIN", "I2C2_SDA")
			FUNCTION_MAP.put("I2C2_SDA_SDAOUT", "I2C2_SDA")
			FUNCTION_MAP.put("I2C2_SMBA_SMBALERTIN", "I2C2_SMBA")
			FUNCTION_MAP.put("I2C2_SMBA_SMBALERTOUT", "I2C2_SMBA")
			FUNCTION_MAP.put("RCC_I2SCLKIN_I2S_CLKIN", "RCC_I2SCLKIN")
			FUNCTION_MAP.put("RCC_LSCO_LSCO_CLK", "RCC_LSCO")
			FUNCTION_MAP.put("RCC_MCO_MCO_CLK", "RCC_MCO")
			FUNCTION_MAP.put("RCC_SD_ADC1_CLK", "RCC_SDADC1_CLKEXT")
			FUNCTION_MAP.put("RCC_SD_ADC2_CLK", "RCC_SDADC2_CLKEXT")
			FUNCTION_MAP.put("SPI1_MISO_AFO_MISO", "SPI1_MISO")
			FUNCTION_MAP.put("SPI1_MISO_MISO_I", "SPI1_MISO")
			FUNCTION_MAP.put("SPI1_MOSI_AFO_MOSI_SD", "SPI1_MOSI")
			FUNCTION_MAP.put("SPI1_MOSI_MOSI_SD_I", "SPI1_MOSI")
			FUNCTION_MAP.put("SPI1_NSS_AFO_NSS_WS", "SPI1_NSS")
			FUNCTION_MAP.put("SPI1_NSS_NSS_IN", "SPI1_NSS")
			FUNCTION_MAP.put("SPI1_SCK_AFO_SCKO", "SPI1_SCK")
			FUNCTION_MAP.put("SPI1_SCK_SCKI", "SPI1_SCK")
			FUNCTION_MAP.put("SPI2_MCK_AFO_MCKO", "SPI2_MCK")
			FUNCTION_MAP.put("SPI2_MISO_AFO_MISO", "SPI2_MISO")
			FUNCTION_MAP.put("SPI2_MISO_MISO_I", "SPI2_MISO")
			FUNCTION_MAP.put("SPI2_MOSI_AFO_MOSI_SD", "SPI2_MOSI")
			FUNCTION_MAP.put("SPI2_MOSI_MOSI_SD_I", "SPI2_MOSI")
			FUNCTION_MAP.put("SPI2_NSS_AFO_NSS_WS", "SPI2_NSS")
			FUNCTION_MAP.put("SPI2_NSS_NSS_IN", "SPI2_NSS")
			FUNCTION_MAP.put("SPI2_SCK_AFO_SCKO", "SPI2_SCK")
			FUNCTION_MAP.put("SPI2_SCK_SCKI", "SPI2_SCK")
			FUNCTION_MAP.put("SPI3_MCK_AFO_MCKO", "SPI3_MCK")
			FUNCTION_MAP.put("SPI3_MISO_AFO_MISO", "SPI3_MISO")
			FUNCTION_MAP.put("SPI3_MISO_MISO_I", "SPI3_MISO")
			FUNCTION_MAP.put("SPI3_MOSI_AFO_MOSI_SD", "SPI3_MOSI")
			FUNCTION_MAP.put("SPI3_MOSI_MOSI_SD_I", "SPI3_MOSI")
			FUNCTION_MAP.put("SPI3_NSS_AFO_NSS_WS", "SPI3_NSS")
			FUNCTION_MAP.put("SPI3_NSS_NSS_IN", "SPI3_NSS")
			FUNCTION_MAP.put("SPI3_SCK_AFO_SCKO", "SPI3_SCK")
			FUNCTION_MAP.put("SPI3_SCK_SCKI", "SPI3_SCK")
			FUNCTION_MAP.put("SPI4_MISO_AFO_MISO", "SPI4_MISO")
			FUNCTION_MAP.put("SPI4_MISO_MISO_I", "SPI4_MISO")
			FUNCTION_MAP.put("SPI4_MOSI_AFO_MOSI_SD", "SPI4_MOSI")
			FUNCTION_MAP.put("SPI4_MOSI_MOSI_SD_I", "SPI4_MOSI")
			FUNCTION_MAP.put("SPI4_NSS_AFO_NSS_WS", "SPI4_NSS")
			FUNCTION_MAP.put("SPI4_NSS_NSS_IN", "SPI4_NSS")
			FUNCTION_MAP.put("SPI4_SCK_AFO_SCKO", "SPI4_SCK")
			FUNCTION_MAP.put("SPI4_SCK_SCKI", "SPI4_SCK")
			FUNCTION_MAP.put("TIM15_BKIN_BRK_0", "TIM15_BKIN")
			FUNCTION_MAP.put("TIM15_CH1N_OCN_1", "TIM15_CH1N")
			FUNCTION_MAP.put("TIM15_CH1_OC_1", "TIM15_CH1")
			FUNCTION_MAP.put("TIM15_CH1_TI1_0", "TIM15_CH1")
			FUNCTION_MAP.put("TIM15_CH2_OC_2", "TIM15_CH2")
			FUNCTION_MAP.put("TIM15_CH2_TI2_0", "TIM15_CH2")
			FUNCTION_MAP.put("TIM16_BKIN_BRK_0", "TIM16_BKIN")
			FUNCTION_MAP.put("TIM16_CH1N_OCN_1", "TIM16_CH1N")
			FUNCTION_MAP.put("TIM16_CH1_OC_1", "TIM16_CH1")
			FUNCTION_MAP.put("TIM16_CH1_TI1_0", "TIM16_CH1")
			FUNCTION_MAP.put("TIM1_PWM_BKIN2_BKIN2", "TIM1_PWM_BKIN2")
			FUNCTION_MAP.put("TIM1_PWM_BKIN_BRK_0", "TIM1_PWM_BKIN")
			FUNCTION_MAP.put("TIM1_PWM_CH1N_OCN_1", "TIM1_PWM_CH1N")
			FUNCTION_MAP.put("TIM1_PWM_CH1_OC_1", "TIM1_PWM_CH1")
			FUNCTION_MAP.put("TIM1_PWM_CH1_TI1_0", "TIM1_PWM_CH1")
			FUNCTION_MAP.put("TIM1_PWM_CH2N_OCN_2", "TIM1_PWM_CH2N")
			FUNCTION_MAP.put("TIM1_PWM_CH2_OC_2", "TIM1_PWM_CH2")
			FUNCTION_MAP.put("TIM1_PWM_CH2_TI2_0", "TIM1_PWM_CH2")
			FUNCTION_MAP.put("TIM1_PWM_CH3N_OCN_3", "TIM1_PWM_CH3N")
			FUNCTION_MAP.put("TIM1_PWM_CH3_OC_3", "TIM1_PWM_CH3")
			FUNCTION_MAP.put("TIM1_PWM_CH3_TI3_0", "TIM1_PWM_CH3")
			FUNCTION_MAP.put("TIM1_PWM_CH4N_OCN_4", "TIM1_PWM_CH4N")
			FUNCTION_MAP.put("TIM1_PWM_CH4_OC_4", "TIM1_PWM_CH4")
			FUNCTION_MAP.put("TIM1_PWM_CH4_TI4_0", "TIM1_PWM_CH4")
			FUNCTION_MAP.put("TIM1_PWM_ETR_ETR", "TIM1_PWM_ETR")
			FUNCTION_MAP.put("TIM2_CH1_OC_1", "TIM2_CH1")
			FUNCTION_MAP.put("TIM2_CH1_TI1_0", "TIM2_CH1")
			FUNCTION_MAP.put("TIM2_CH2_OC_2", "TIM2_CH2")
			FUNCTION_MAP.put("TIM2_CH2_TI2_0", "TIM2_CH2")
			FUNCTION_MAP.put("TIM2_CH3_OC_3", "TIM2_CH3")
			FUNCTION_MAP.put("TIM2_CH3_TI3_0", "TIM2_CH3")
			FUNCTION_MAP.put("TIM2_CH4_OC_4", "TIM2_CH4")
			FUNCTION_MAP.put("TIM2_CH4_TI4_0", "TIM2_CH4")
			FUNCTION_MAP.put("TIM2_ETR_ETR", "TIM2_ETR")
			FUNCTION_MAP.put("TIM3_CH1_OC_1", "TIM3_CH1")
			FUNCTION_MAP.put("TIM3_CH1_TI1_0", "TIM3_CH1")
			FUNCTION_MAP.put("TIM3_CH2_OC_2", "TIM3_CH2")
			FUNCTION_MAP.put("TIM3_CH2_TI2_0", "TIM3_CH2")
			FUNCTION_MAP.put("TIM3_CH3_OC_3", "TIM3_CH3")
			FUNCTION_MAP.put("TIM3_CH3_TI3_0", "TIM3_CH3")
			FUNCTION_MAP.put("TIM3_CH4_OC_4", "TIM3_CH4")
			FUNCTION_MAP.put("TIM3_CH4_TI4_0", "TIM3_CH4")
			FUNCTION_MAP.put("TIM3_ETR_ETR", "TIM3_ETR")
			FUNCTION_MAP.put("TIM4_CH1_OC_1", "TIM4_CH1")
			FUNCTION_MAP.put("TIM4_CH1_TI1_0", "TIM4_CH1")
			FUNCTION_MAP.put("TIM4_CH2_OC_2", "TIM4_CH2")
			FUNCTION_MAP.put("TIM4_CH2_TI2_0", "TIM4_CH2")
			FUNCTION_MAP.put("TIM4_CH3_OC_3", "TIM4_CH3")
			FUNCTION_MAP.put("TIM4_CH3_TI3_0", "TIM4_CH3")
			FUNCTION_MAP.put("TIM4_CH4_OC_4", "TIM4_CH4")
			FUNCTION_MAP.put("TIM4_CH4_TI4_0", "TIM4_CH4")
			FUNCTION_MAP.put("TIM4_ETR_ETR", "TIM4_ETR")
			FUNCTION_MAP.put("TIM5_CH1_OC_1", "TIM5_CH1")
			FUNCTION_MAP.put("TIM5_CH1_TI1_0", "TIM5_CH1")
			FUNCTION_MAP.put("TIM5_CH2_OC_2", "TIM5_CH2")
			FUNCTION_MAP.put("TIM5_CH2_TI2_0", "TIM5_CH2")
			FUNCTION_MAP.put("TIM5_CH3_OC_3", "TIM5_CH3")
			FUNCTION_MAP.put("TIM5_CH3_TI3_0", "TIM5_CH3")
			FUNCTION_MAP.put("TIM5_CH4_OC_4", "TIM5_CH4")
			FUNCTION_MAP.put("TIM5_CH4_TI4_0", "TIM5_CH4")
			FUNCTION_MAP.put("TIM5_ETR_ETR", "TIM5_ETR")
			FUNCTION_MAP.put("TIM8_PWM_BKIN2_BKIN2", "TIM8_PWM_BKIN2")
			FUNCTION_MAP.put("TIM8_PWM_BKIN_BRK_0", "TIM8_PWM_BKIN")
			FUNCTION_MAP.put("TIM8_PWM_CH1N_OCN_1", "TIM8_PWM_CH1N")
			FUNCTION_MAP.put("TIM8_PWM_CH1_OC_1", "TIM8_PWM_CH1")
			FUNCTION_MAP.put("TIM8_PWM_CH1_TI1_0", "TIM8_PWM_CH1")
			FUNCTION_MAP.put("TIM8_PWM_CH2N_OCN_2", "TIM8_PWM_CH2N")
			FUNCTION_MAP.put("TIM8_PWM_CH2_OC_2", "TIM8_PWM_CH2")
			FUNCTION_MAP.put("TIM8_PWM_CH2_TI2_0", "TIM8_PWM_CH2")
			FUNCTION_MAP.put("TIM8_PWM_CH3N_OCN_3", "TIM8_PWM_CH3N")
			FUNCTION_MAP.put("TIM8_PWM_CH3_OC_3", "TIM8_PWM_CH3")
			FUNCTION_MAP.put("TIM8_PWM_CH3_TI3_0", "TIM8_PWM_CH3")
			FUNCTION_MAP.put("TIM8_PWM_CH4N_OCN_4", "TIM8_PWM_CH4N")
			FUNCTION_MAP.put("TIM8_PWM_CH4_OC_4", "TIM8_PWM_CH4")
			FUNCTION_MAP.put("TIM8_PWM_CH4_TI4_0", "TIM8_PWM_CH4")
			FUNCTION_MAP.put("TIM8_PWM_ETR_ETR", "TIM8_PWM_ETR")
			FUNCTION_MAP.put("UART1_RX_RX_IN", "UART1_RX")
			FUNCTION_MAP.put("UART1_RX_RX_OUT", "UART1_RX")
			FUNCTION_MAP.put("UART1_TX_TX_IN", "UART1_TX")
			FUNCTION_MAP.put("UART1_TX_TX_OUT", "UART1_TX")
			FUNCTION_MAP.put("UART2_RX_RX_IN", "UART2_RX")
			FUNCTION_MAP.put("UART2_RX_RX_OUT", "UART2_RX")
			FUNCTION_MAP.put("UART2_TX_TX_IN", "UART2_TX")
			FUNCTION_MAP.put("UART2_TX_TX_OUT", "UART2_TX")
			FUNCTION_MAP.put("UART3_RX_RX_IN", "UART3_RX")
			FUNCTION_MAP.put("UART3_RX_RX_OUT", "UART3_RX")
			FUNCTION_MAP.put("UART3_TX_TX_IN", "UART3_TX")
			FUNCTION_MAP.put("UART3_TX_TX_OUT", "UART3_TX")

		}
		FUNCTION_MAP.get(bitfieldStr)
	}

	static Map<String, String> MODULES_MAP = null

	def getNewPeripheralName(String bitfieldStr) {
		if (MODULES_MAP === null) {
			MODULES_MAP = newHashMap
			MODULES_MAP.put("BDAC1", "BDAC")
			MODULES_MAP.put("BDAC2", "BDAC")
			MODULES_MAP.put("B_DAC", "BDAC")
		}
		MODULES_MAP.get(bitfieldStr)
	}

	override apply(String inputFilePath, String outputFilePath) {

		try (val br = new BufferedReader(new FileReader(inputFilePath));
             val bw = new BufferedWriter(new FileWriter(outputFilePath))) {

			var line = "";
			while ((line = br.readLine()) !== null) {
				// Write the modified or unmodified line to the output file
				bw.write(line);
				bw.newLine(); // Add a new line after each line
			}
		} catch (IOException e) {
			e.printStackTrace();
		}

		try (val br = new BufferedReader(new FileReader(outputFilePath));
             val bw = new BufferedWriter(new FileWriter(inputFilePath))) {

			var line = "";
			while ((line = br.readLine()) !== null) {
				line = replaceVersionLine(line)
				line = replaceVersionBoardLine(line)
				line = replaceFunctionLine(line)
				line = replacePeripheralLine(line)
				// Write the modified or unmodified line to the output file
				bw.write(line);
				bw.newLine(); // Add a new line after each line
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	def String replaceFunctionLine(String readLine) {
		var line = readLine
		// Apply the change to lines that match the regular expression for functions
		val pattern = Pattern.compile("^(.*)\\s+([a-zA-Z_0-9]+)(\\s*->\\s*.+)$")
		val matcher = pattern.matcher(line)

		if (matcher.find()) {
			// Modify the line as needed
			val replacement = getNewFunctionName(matcher.group(2))
			if (replacement !== null) {
				println('''«matcher.group(2)» replaced by «replacement»''')
				line = line.replaceFirst(matcher.group(2), replacement)
				if (matcher.group(2).contains("I2C")) {
					line = line.replaceFirst(matcher.group(1), "inout")
				}
			} else {
				println(line)
			}
		}
		line
	}

	def String replaceVersionLine(String readLine) {
		var line = readLine
		// Apply the change to lines that match the regular expression for version
		val pattern = Pattern.compile("^include.*version \"([0-9]*\\.[0-9]*\\.[0-9]*)\"$")
		val matcher = pattern.matcher(line)

		if (matcher.find()) {
			// Modify the line as needed
			val replacement = "2.0.0"
			println('''«matcher.group(1)» replaced by «replacement»''')
			line = line.replaceFirst(matcher.group(1), replacement)
		} else {
			if( line.startsWith("include")) {
				line = line + ''' version "2.0.0"'''
			}
		}
		line
	}


	def String replaceVersionBoardLine(String readLine) {
		var line = readLine
		// Apply the change to lines that match the regular expression for version
		val pattern = Pattern.compile("^Board.*version \"([0-9]*\\.[0-9]*\\.[0-9]*)\"$")
		val matcher = pattern.matcher(line)

		if (matcher.find()) {
			// Modify the line as needed
			val replacement = "2.0.0"
			println('''«matcher.group(1)» replaced by «replacement»''')
			line = line.replaceFirst(matcher.group(1), replacement)
		} else {
			if( line.startsWith("Board")) {
				line = line + ''' version "2.0.0"'''
			}
		}
		line
	}
	def String replacePeripheralLine(String readLine) {
		var line = readLine
		// Apply the change to lines that match the regular expression for Peripherals
		val pattern = Pattern.compile("^(.*)\\s+(.*)\\{")
		val matcher = pattern.matcher(line)

		if (matcher.find()) {
			// Modify the line as needed
			val replacement = getNewPeripheralName(matcher.group(1))
			if (replacement !== null) {
				println('''«matcher.group(1)» replaced by «replacement»''')
				line = line.replaceFirst(matcher.group(1), replacement)
			}
		}
		line
	}

}
