/****************************************************************************
*
* Copyright (c) 2024 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* EVALUATION ONLY - NOT FOR USE IN PRODUCTION
*****************************************************************************/

#include <test_env.h>
#include <tim_cfg.h>

/*===========================================================================*/
/* TIM-related.                                                              */
/*===========================================================================*/

/* TIM1 ch1 (PWM) callback */
void tim1_ch1_callback(tim_driver_t *tdp)
{
    (void)(tdp);
    /* Blink USER_LED_A.*/
    gpio_toggle_pin(USER_LED_A);
}

/* TIM1 ch2 (ICU) callback */
void tim1_ch2_callback(tim_driver_t *tdp)
{
    (void)(tdp);
    /* Blink USER_LED_B.*/
    gpio_toggle_pin(USER_LED_B);
}

int main(void) {

    /* Enable interrupts.*/
    osal_sys_unlock();

    test_env_init((TestInit_t)
                  (TEST_INIT_CLOCK    |
                   TEST_INIT_GPIO     |
                   TEST_INIT_BOARD    |
                   TEST_INIT_IRQ      |
                   TEST_INIT_OSAL));

    /* Switch-off user leds.*/
    USER_LED_SWITCH_OFF(USER_LED_A);
    USER_LED_SWITCH_OFF(USER_LED_B);

    /* Initialize TIM driver instance.*/
    tim_init(&TIMD);

    /* Configure TIM driver.*/
    tim_config1(&TIMD);

    /* Apply TIM configuration.*/
    tim_start(&TIMD);

    /* Enable TIM1 channel 1 and TIM1 channel 2 callbacks.*/
    tim_enable_channel_callback(&TIMD, 1U);
    tim_enable_channel_callback(&TIMD, 2U);

    /* Start PWM on TIM1 channel 1 (frequency 2Hz, duty cycle 50%) and ICU on
       TIM1 channel 2.*/
    tim_set_interval(&TIMD, 50000U);        /* 100kHz/50000 = 2Hz. */
    tim_set_comparator(&TIMD, 1U, 25000U);  /* Duty cycle 50%.     */

    /* Enable TIM.*/
    tim_enable(&TIMD);

    /* Application main loop */
    for ( ; ; ) {
        osal_delay_millisec(500U);
    }
}
