/****************************************************************************
*
* Copyright (c) 2022 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* PLEASE NOTE THAT THIS FILE IS GENERATED FROM A CONFIGURATION FILE,
* USING com.st.stellar.pinmap.gpiocfg, Version 2.1.0.202406141217
* MODIFYING IT IMPLIES POTENTIAL LOSS OF YOUR MODIFICATIONS.
*
*****************************************************************************/
/**
 * @file    Config.h
 * @brief   SR5E1-MYBOARD board header file.
 *
 * @addtogroup PLATFORM
 * @addtogroup BOARD
 * @ingroup PLATFORM
 * @addtogroup CONFIG
 * @ingroup BOARD
 * @{
 */

#ifndef _CONFIG_H_
#define _CONFIG_H_

#include <gpio.h>
#include <platform.h>
#include <typedefs.h>


/*===========================================================================*/
/* Module constants.                                                         */
/*===========================================================================*/

#define MYBOARD	1

/*--------------------- GPIO pins definitions ---------------------*/
#define USER_LED_A gpio_iopack(GPIO_PORT_E, GPIO_PIN_13) /* PE[13] */
#define USER_LED_A_CFG                              \
	(GPIO_MODE_MODER_OUTPUT |                       \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(0U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)

#define USER_BUTTON_A gpio_iopack(GPIO_PORT_E, GPIO_PIN_15) /* PE[15] */
#define USER_BUTTON_A_CFG                           \
	(GPIO_MODE_MODER_INPUT |                        \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(0U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)



/*===========================================================================*/
/* Module pre-compile time settings.                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Derived constants and error checks.                                       */
/*===========================================================================*/

/*===========================================================================*/
/* Module data structures and types.                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Module macros.                                                            */
/*===========================================================================*/

/*===========================================================================*/
/* External declarations.                                                    */
/*===========================================================================*/

#if !defined(_FROM_ASM_)
#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif
#endif /* _FROM_ASM_ */

/*===========================================================================*/
/* Module inline functions.                                                  */
/*===========================================================================*/


__STATIC_INLINE void Config_init(void) {
	
	/* GPIO */
	gpio_set_pin_mode(USER_LED_A, USER_LED_A_CFG);
	gpio_set_pin_mode(USER_BUTTON_A, USER_BUTTON_A_CFG);

}

/*===========================================================================*/
/* Module late inclusions.                                                   */
/*===========================================================================*/

#endif /* _CONFIG_H_ */

/** @} */

