/****************************************************************************
 *
 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
 *
 * License terms: STMicroelectronics Proprietary in accordance with licensing
 * terms SLA0098 at www.st.com.
 *
 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * DO NOT EDIT: Automatically generated file
 *****************************************************************************/

#include <spi_cfg.h>
#include <dma.h>
#include <irq.h>

/* Internal configuration data.*/

static spi_dma_conf_t master_cfg_dma_conf = {
	DMA1_STREAM0_ID,
	DMA1_STREAM1_ID,
	DMA_PRIORITY_MAX,
	IRQ_PRIORITY_10
};
static spi_dma_conf_t slave_cfg_dma_conf = {
	DMA1_STREAM2_ID,
	DMA1_STREAM3_ID,
	DMA_PRIORITY_MAX,
	IRQ_PRIORITY_10
};

/* Exported configuration APIs.*/

void spi_master_cfg(spi_driver_t *sdp) {

	/* Configure spi driver instance.*/
	(void)spi_set_mode(sdp, SPI_MODE_MASTER);
	(void)spi_set_nssp_mode(sdp, SPI_NSS_PULSE_MODE_OFF);
	(void)spi_set_nss_mode(sdp, SPI_NSS_MODE_HARDWARE);
	(void)spi_set_drv_mode(sdp, SPI_DRV_MODE_DMA_ASYNC);
	spi_set_dma_conf(sdp, &master_cfg_dma_conf);
	(void)spi_set_cmode(sdp, SPI_CMODE_FULL_DUPLEX);
	(void)spi_set_baud(sdp, SPI_BAUDRATE_DIV8);
	(void)spi_set_fformat(sdp, SPI_FRAMEFORMAT_MSB);
	(void)spi_set_fsize(sdp, SPI_FRAMESIZE_8);
	(void)spi_set_cpha(sdp, SPI_CPHA_0);
	(void)spi_set_cpol(sdp, SPI_CPOL_0);
	(void)spi_set_cb(sdp, SPI_CB_OPS_DONE, spi_master_data_cb);
	(void)spi_set_cb(sdp, SPI_CB_OPS_ERR, spi_master_err_cb);
}

void spi_slave_cfg(spi_driver_t *sdp) {

	/* Configure spi driver instance.*/
	(void)spi_set_mode(sdp, SPI_MODE_SLAVE);
	(void)spi_set_drv_mode(sdp, SPI_DRV_MODE_DMA_ASYNC);
	spi_set_dma_conf(sdp, &slave_cfg_dma_conf);
	(void)spi_set_cmode(sdp, SPI_CMODE_FULL_DUPLEX);
	(void)spi_set_baud(sdp, SPI_BAUDRATE_DIV4);
	(void)spi_set_fformat(sdp, SPI_FRAMEFORMAT_MSB);
	(void)spi_set_fsize(sdp, SPI_FRAMESIZE_8);
	(void)spi_set_cpha(sdp, SPI_CPHA_0);
	(void)spi_set_cpol(sdp, SPI_CPOL_0);
	(void)spi_set_cb(sdp, SPI_CB_OPS_DONE, spi_slave_data_cb);
	(void)spi_set_cb(sdp, SPI_CB_OPS_ERR, spi_slave_err_cb);
}
