/****************************************************************************
 *
 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
 *
 * License terms: STMicroelectronics Proprietary in accordance with licensing
 * terms SLA0098 at www.st.com.
 *
 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * DO NOT EDIT: Automatically generated file
 *****************************************************************************/

#include <saradc_cfg.h>
#include <dma.h>
#include <irq.h>

/* Internal configuration data.*/
/* Regular conversions DMA configuration.*/
static adc_dma_conf_t config1_reg_dma_conf = {
	DMA_STREAM_ID_ANY,
	DMA_PRIORITY_MAX,
	IRQ_PRIORITY_10
	};

/* Regular conversions data buffer.*/
adc_sample_t adc_reg_buffer[1];

/* Regular conversion sequence.*/
uint8_t config1_reg_seq[1] = {
ADC_CH_IN1,
};

/* Exported configuration APIs.*/
void adc_config1(adc_driver_t *adp) {
	
	/* Configure saradc driver instance.*/
	(void)adc_set_data_res(adp, ADC_DATA_RES_8);
	(void)adc_set_prio(adp, IRQ_PRIORITY_15);
	(void)adc_set_clk_mode(adp, ADC_CLK_MODE_ADCCLK);
	(void)adc_set_presc(adp, ADC_CLK_PRESC_DIV_1);
	/* Regular conversions configuration.*/
	adc_set_dma_conf(adp, &config1_reg_dma_conf);
	(void)adc_set_err_cb(adp, ADC_ERR_DMA, adc_err_cb);
	(void)adc_set_reg_mode(adp, ADC_REG_CONTINUOUS);
	
	adc_set_seq(adp, ADC_REG_CONV, 1U, config1_reg_seq, adc_reg_buffer);
	(void)adc_set_smp_time(adp, ADC_CH_IN1, ADC_SMP_2P5);
	(void)adc_set_dif_sel(adp, 0U << 1);
	(void)adc_set_op_cb(adp, ADC_OP_REG_CONV, adc_reg_data_cb);
	
	/* Enable ADC interrupts.*/
	(void)adc_set_interrupt_en(adp, true);
}
