/****************************************************************************
 *
 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
 *
 * License terms: STMicroelectronics Proprietary in accordance with licensing
 * terms SLA0098 at www.st.com.
 *
 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *****************************************************************************/

#include <test_env.h>
#include <hrtim_cfg.h>

/* HRTIM Master callback.*/
void hrtim_master_callback(hrtim_driver_t *hdp, uint32_t events)
{
    (void)(hdp);
    (void)(events);

    /* Blink USER_LED_A.*/
    gpio_toggle_pin(USER_LED_A);
}

/* HRTIM TimerF callback.*/
void hrtim_timer_callback(hrtim_driver_t *hdp, uint32_t events)
{
    (void)(hdp);
    (void)(events);

    /* Blink USER_LED_B.*/
    gpio_toggle_pin(USER_LED_B);
}

int main(void)
{
    /* Enable interrupts.*/
    osal_sys_unlock();

    test_env_init((TestInit_t)
                  (TEST_INIT_CLOCK    |
                   TEST_INIT_GPIO     |
                   TEST_INIT_BOARD    |
                   TEST_INIT_IRQ      |
                   TEST_INIT_OSAL));

    /* Switch-off user leds.*/
    USER_LED_SWITCH_OFF(USER_LED_A);
    USER_LED_SWITCH_OFF(USER_LED_B);

    /* Initialize HRTIM driver instance.*/
    hrtim_init(&HRTIMD);

    /* Configure the driver instance.*/
    hrtim_config(&HRTIMD);

    /* Apply HRTIM driver instance configuration.*/
    hrtim_start(&HRTIMD);

    hrtim_enable_cb(&HRTIMD, HRTIM_CB_MASTER, HRTIM_CB_EVENT_REP);
    hrtim_enable_cb(&HRTIMD, HRTIM_CB_TIMER_F, HRTIM_CB_EVENT_REP);

    /* Configure HRTIM Master and TimerF repetition values to 200. This triggers
       an interrupt each 200 * period = 100ms.*/
    hrtim_timer_set_repetition(&HRTIMD, HRTIM_TIMER_MASTER, 199U);
    hrtim_timer_set_repetition(&HRTIMD, HRTIM_TIMER_F, 199U);

    /* Enable HRTIM Master and TimerF.*/
    (void)hrtim_timer_enable_output(&HRTIMD, HRTIM_TIMER_F_OUT1_MASK_ID | HRTIM_TIMER_F_OUT2_MASK_ID);
    (void)hrtim_timer_enable(&HRTIMD, HRTIM_TIMER_F_MASK_ID | HRTIM_TIMER_MASTER_MASK_ID);

    /* Application main loop */
    for ( ; ; ) {
        osal_delay_millisec(250U);
    }
}
