/****************************************************************************
*
* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* EVALUATION ONLY - NOT FOR USE IN PRODUCTION
*****************************************************************************/

#include <test_env.h>
#include <can_cfg.h>

#define CAN_DEFAULT_FILTER_ID               0x7F0UL

#define CAN_DEFAULT_RX_BUFF_NUM             4U
#define CAN_DEFAULT_TX_BUFF_NUM             4U
#define CAN_DEFAULT_RX_FIFO0_NUM            4U
#define CAN_DEFAULT_RX_FIFO1_NUM            4U
#define CAN_DEFAULT_TX_FIFOQ_NUM            4U

#define CAN_DATA_TO_SEND                    0xF0CACC1AUL
#define CAN_MESSAGE_SIZE                    8U

static uint8_t i = 0U;

/* This callback is invoked when a frame is received.*/
void canrx_receive_cb(can_driver_t *cdp, can_frame_t frame, can_evt_t event) {

    (void)cdp;
    (void)frame;
    (void)event;

    /* Verify the received frame is equal to trasmitted frame.*/
    if ((event == CAN_CB_RX)                  &&
        (frame.TYPE == CAN_ID_STD)            &&
        (frame.ID == CAN_DEFAULT_FILTER_ID)   &&
        (frame.data32[0] == CAN_DATA_TO_SEND) &&
        (frame.data32[1] == i)) {
        gpio_toggle_pin(USER_LED_B);
        i++;
    } else {
        while(1);
    }
}

/* This callback is invoked when an error occurs during reception.*/
void canrx_error_cb(can_driver_t *cdp, uint32_t psr) {

    (void)cdp;
    (void)psr;
    while(1);
}

/* This callback is invoked when an error occurs during transmission.*/
void cantx_error_cb(can_driver_t *cdp, uint32_t psr) {

    (void)cdp;
    (void)psr;
    while(1);
}

int main(void)
{
	bool status;
	can_frame_t frame;

    /* Enable interrupts.*/
    osal_sys_unlock();

	test_env_init((TestInit_t)
                  (TEST_INIT_CLOCK    |
                   TEST_INIT_GPIO     |
                   TEST_INIT_BOARD    |
                   TEST_INIT_IRQ      |
                   TEST_INIT_OSAL));
	/* Switch-off user leds.*/
	USER_LED_SWITCH_OFF(USER_LED_A);
	USER_LED_SWITCH_OFF(USER_LED_B);

	/* Initialize CAN RX/TX driver instances.*/
	can_init(&CANRXD);
	can_init(&CANTXD);

	/* Configure CAN driver instances with GUI-generated code.*/
	can_rx_config(&CANRXD);
	can_tx_config(&CANTXD);

	/* Apply CAN RX/TX configurations.*/
	can_start(&CANRXD);
	can_start(&CANTXD);

	/* Prepare frame to transmit.*/
	frame.TYPE = CAN_ID_STD;
	frame.ID = CAN_DEFAULT_FILTER_ID;
	frame.DLC = CAN_MESSAGE_SIZE;
	frame.data32[0] = CAN_DATA_TO_SEND;
	frame.OPERATION = CAN_OPERATION_NORMAL;

    /* Application main loop */
    for ( ; ; ) {
    	frame.data32[1] = i;
    	status = can_transmit(&CANTXD, CAN_TX_ANY_BUFFER, &frame);
    	if (status == false) {
    	    while(1);
    	}
    	/* Blink USER_LED_A.*/
    	gpio_toggle_pin(USER_LED_A);
    	osal_delay_millisec(500U);
    }
}
