/****************************************************************************
*
* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* EVALUATION ONLY - NOT FOR USE IN PRODUCTION
*****************************************************************************/

#include <test_env.h>
#include <uart_cfg.h>

int main(void)
{
    /* Enable interrupts.*/
    osal_sys_unlock();

	test_env_init((TestInit_t)
                  (TEST_INIT_CLOCK    |
                   TEST_INIT_GPIO     |
                   TEST_INIT_BOARD    |
                   TEST_INIT_IRQ      |
                   TEST_INIT_OSAL));

	/* Initialize UART driver instance.*/
	uart_init(&UARTD);

	/* Configure UART driver instance with GUI-generated code.*/
	uart_cfg(&UARTD);

	/* Apply UART driver instance configuration.*/
	uart_start(&UARTD);

    /* Application main loop */
    for ( ; ; ) {
    	/* Write message on UART.*/
    	(void)uart_write(&UARTD, (uint8_t *)"Hello World!!!\n\r", 16U);

        /* Blink USER_LED_A.*/
    	gpio_toggle_pin(USER_LED_A);
        osal_delay_millisec(250U);
    }
}
