/****************************************************************************
 *
 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
 *
 * License terms: STMicroelectronics Proprietary in accordance with licensing
 * terms SLA0098 at www.st.com.
 *
 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * DO NOT EDIT: Automatically generated file
 *****************************************************************************/

#include <tim_cfg.h>
#include <dma.h>

/* Exported configuration APIs.*/
void tim_config1(tim_driver_t *tdp) {
	
	/* Configure tim driver instance.*/
	(void)tim_set_prio(tdp, IRQ_PRIORITY_15);
	(void)tim_set_presc(tdp, 2999);
	(void)tim_enable_opm(tdp, 0);
	(void)tim_set_ckd(tdp, TIM_CKD_1);
	(void)tim_set_cms(tdp, TIM_CMS_EDGE_ALIGNED);
	(void)tim_set_dt(tdp, 0, 0);
	
	/* Configure channel 1.*/
	(void)tim_set_ic_filter(tdp, 1, TIM_ICF_NO_FILTER);
	(void)tim_set_ch_mode(tdp, 1, TIM_MODE_PWM_ACTIVE_HIGH);
	
	
	/* Configure channel 2.*/
	(void)tim_set_ic_filter(tdp, 2, TIM_ICF_NO_FILTER);
	(void)tim_set_ch_mode(tdp, 2, TIM_MODE_ICU_FALLING_EDGE);
	
	
	
	
	
	(void)tim_set_trgo(tdp, TIM_TRGO_RESET);
	(void)tim_set_trgo2(tdp, TIM_TRGO2_RESET);
	
	(void)tim_set_sms(tdp, TIM_SMODE_DISABLED);
	
	(void)tim_set_trgi(tdp, TIM_TRGI_ITR0);
	
	/* Configure external trigger.*/
	(void)tim_set_etf(tdp, 0);
	(void)tim_set_etps(tdp, TIM_ETPS_DIV1);
	(void)tim_set_etp(tdp, TIM_ETP_NOT_INVERTED);
	
	
	(void)tim_set_ti1_selection(tdp, TIM_TI1S_TI1);
	(void)tim_enable_preload_control(tdp, 0);
	
	/* Configure callbacks.*/
	(void)tim_set_cb(tdp, TIM_CB_OPS_CC1, tim1_ch1_callback);
	(void)tim_set_cb(tdp, TIM_CB_OPS_CC2, tim1_ch2_callback);
}
