/****************************************************************************
*
* Copyright (c) 2024 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/

#include <test_env.h>
#include <tim.h>

/*===========================================================================*/
/* TIM-related.                                                              */
/*===========================================================================*/

/* TIM1 ch1 (PWM) callback */
void tim1_ch1_callback(tim_driver_t *tdp)
{
    (void)(tdp);
    /* Blink USER_LED_A.*/
    gpio_toggle_pin(USER_LED_1);
}

/* TIM1 ch2 (ICU) callback */
void tim1_ch2_callback(tim_driver_t *tdp)
{
    (void)(tdp);
    /* Blink USER_LED_B.*/
    gpio_toggle_pin(USER_LED_2);
}

int main(void) {

    /* Enable interrupts.*/
    osal_sys_unlock();

	test_env_init((TestInit_t)
                  (TEST_INIT_CLOCK    |
                   TEST_INIT_GPIO     |
                   TEST_INIT_BOARD    |
                   TEST_INIT_IRQ      |
                   TEST_INIT_OSAL));

    /* Initialize TIM driver instance.*/
    tim_init(&DRV_TIM1);

    /* Configure TIM driver.*/
    (void)tim_set_presc(&DRV_TIM1, TIM_DIVIDE_BY(tim_get_clock(&DRV_TIM1) / 100000U));
    (void)tim_set_ch_mode(&DRV_TIM1, 1U, TIM_MODE_PWM_ACTIVE_HIGH);
    (void)tim_set_ch_mode(&DRV_TIM1, 2U, TIM_MODE_PWM_ACTIVE_LOW);
    (void)tim_set_cb(&DRV_TIM1, TIM_CB_OPS_CC1, tim1_ch1_callback);
    (void)tim_set_cb(&DRV_TIM1, TIM_CB_OPS_CC2, tim1_ch2_callback);

    /* Apply TIM configuration.*/
    tim_start(&DRV_TIM1);

    /* Enable TIM1 channel 1 and TIM1 channel 2 callbacks.*/
    tim_enable_channel_callback(&DRV_TIM1, 1U);
    tim_enable_channel_callback(&DRV_TIM1, 2U);

    /* Start PWM on TIM1 channel 1 / 2 (frequency 2Hz, duty cycle 50%) */
    tim_set_interval(&DRV_TIM1, 50000U);        /* 100kHz/50000 = 2Hz. */
    tim_set_comparator(&DRV_TIM1, 1U, 25000U);  /* Duty cycle 50%.     */
    tim_set_comparator(&DRV_TIM1, 2U, 25000U);  /* Duty cycle 50%.     */

    /* Enable TIM.*/
    tim_enable(&DRV_TIM1);

    /* Application main loop */
    for ( ; ; ) {
        osal_delay_millisec(500U);
    }
}
