/****************************************************************************
*
* Copyright (c) 2024 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* EVALUATION ONLY - NOT FOR USE IN PRODUCTION
*****************************************************************************/

#include <test_env.h>
#include "exti.h"

int blinking = 1;

void exti_pe15_cb(void) {
	/* Toggle the blinking state */
	blinking = (blinking)?0:1;
}


int main(void)
{
    /* Enable interrupts.*/
    osal_sys_unlock();

	test_env_init((TestInit_t)
                  (TEST_INIT_CLOCK    |
                   TEST_INIT_GPIO     |
                   TEST_INIT_BOARD    |
                   TEST_INIT_IRQ      |
                   TEST_INIT_OSAL));

	/* Configure the falling edged interrupt on USER_BUTTON_A (PE[15]) */
	exti_set_line(EXTI_LINE_15, EXTI_MODE_INTERRUPT, EXTI_TRIGGER_FALLING);
	exti_set_port(EXTI_LINE_15, EXTI_PORT_E);
	exti_set_irq(EXTI_LINE_15, IRQ_PRIORITY_5, exti_pe15_cb);

    /* Application main loop */
    for ( ; ; ) {
    	if (blinking) {
            /* Blink USER_LED_A.*/
    		gpio_toggle_pin(USER_LED_A);
    	} else {
            /* Clear USER_LED_A.*/
    		gpio_clear_pin(USER_LED_A);
    	}
        osal_delay_millisec(100U);
    }
}
