/****************************************************************************
 *
 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
 *
 * License terms: STMicroelectronics Proprietary in accordance with licensing
 * terms SLA0098 at www.st.com.
 *
 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * DO NOT EDIT: Automatically generated file
 *****************************************************************************/

#include <hrtim_cfg.h>

/* Exported configuration APIs.*/
void hrtim_config(hrtim_driver_t *hdp) {

	/* Configure hrtim driver instance.*/
	(void)hrtim_set_prio(hdp, 15);
	(void)hrtim_set_fault_prsc(hdp, HRTIM_FAULTPRESCALER_DIV1);
	(void)hrtim_set_sync_in(hdp, HRTIM_SYNCIN_NONE);
	(void)hrtim_set_sync_out(hdp, HRTIM_SYNCOUT_DISABLED);
	(void)hrtim_set_sync_src(hdp, HRTIM_SYNCSRC_MASTER_START);

	/* ADC trigger event settings.*/

	/* External event settings.*/
	(void)hrtim_set_event_prescaler(hdp, HRTIM_EVENTPRESCALER_DIV1);

	/* Timer Master settings.*/
	(void)hrtim_set_timer_mode(hdp, HRTIM_TIMER_MASTER, HRTIM_MODE_CONTINUOS);
	(void)hrtim_timer_set_half_intlvd_mode(hdp, HRTIM_TIMER_MASTER, HRTIM_MODE_HALF_INTLVD_DISABLED);
	(void)hrtim_timer_set_prescaler(hdp, HRTIM_TIMER_MASTER, HRTIM_PRSC_DIV4);
	(void)hrtim_timer_set_period(hdp, HRTIM_TIMER_MASTER, 37500U);
	(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP1, 18750U);
	(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP2, 0U);
	(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP3, 0U);
	(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP4, 0U);
	hrtim_timer_set_preload_update(hdp, HRTIM_TIMER_MASTER, HRTIM_PRELOAD_DISABLED, HRTIM_MSTUPDATETRIGGER_REPETITION);
	(void)hrtim_set_cb(hdp, HRTIM_CB_MASTER, hrtim_master_callback);
	(void)hrtim_enable_sync_start(hdp, HRTIM_TIMER_MASTER, false);
	(void)hrtim_enable_sync_reset(hdp, HRTIM_TIMER_MASTER, false);

	/* HRTIM_TIMER_F settings.*/
	(void)hrtim_set_timer_mode(hdp, HRTIM_TIMER_F, HRTIM_MODE_CONTINUOS);
	(void)hrtim_timer_set_up_down_mode(hdp, HRTIM_TIMER_F, HRTIM_COUNTING_MODE_UP);
	(void)hrtim_timer_set_prescaler(hdp, HRTIM_TIMER_F, HRTIM_PRSC_DIV4);
	(void)hrtim_timer_set_period(hdp, HRTIM_TIMER_F, 37500U);
	(void)hrtim_timer_set_counter_reset_event(hdp, HRTIM_TIMER_F, HRTIM_COUNTER_RESET_NOEVENT);
	(void)hrtim_timer_set_half_intlvd_mode(hdp, HRTIM_TIMER_F, HRTIM_MODE_HALF_INTLVD_DISABLED);
	(void)hrtim_timer_set_preload_update(hdp, HRTIM_TIMER_F, HRTIM_PRELOAD_DISABLED, HRTIM_TIMUPDATETRIGGER_NONE);
	(void)hrtim_set_cb(hdp, HRTIM_CB_TIMER_F, hrtim_timer_callback);
	(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_F, HRTIM_CMP1, 18750U);
	(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_F, HRTIM_CMP2, 0U);
	(void)hrtim_timer_set_autodelay(hdp, HRTIM_TIMER_F, HRTIM_CMP2, HRTIM_CMP_AD_MODE_STANDARD);
	(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_F, HRTIM_CMP3, 0U);
	(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_F, HRTIM_CMP4, 0U);
	(void)hrtim_timer_set_autodelay(hdp, HRTIM_TIMER_F, HRTIM_CMP4, HRTIM_CMP_AD_MODE_STANDARD);
	hrtim_timer_set_deadtime(hdp, HRTIM_TIMER_F, HRTIM_DT_PRSC_MUL16, 469U, HRTIM_DT_SIGN_POSITIVE, 469U, HRTIM_DT_SIGN_POSITIVE);
	hrtim_timer_enable_deadtime(hdp, HRTIM_TIMER_F);
	(void)hrtim_enable_sync_start(hdp, HRTIM_TIMER_F, false);
	(void)hrtim_enable_sync_reset(hdp, HRTIM_TIMER_F, false);
	(void)hrtim_timer_set_outputset(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_1, HRTIM_OUTPUT_TIMCMP1);
	(void)hrtim_timer_set_outputrst(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_1, HRTIM_OUTPUT_TIMPER);
	(void)hrtim_timer_set_output_faultstate(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_1, HRTIM_OUTPUT_FAULTSTATE_NOACTIVE);
	(void)hrtim_timer_set_output_idlestate(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_1, HRTIM_OUTPUT_IDLESTATE_INACTIVE);
	(void)hrtim_timer_set_output_polarity(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_1, HRTIM_OUTPUT_POLARITY_POSITIVE);
	(void)hrtim_timer_set_outputset(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_2, HRTIM_OUTPUT_NONE);
	(void)hrtim_timer_set_outputrst(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_2, HRTIM_OUTPUT_NONE);
	(void)hrtim_timer_set_output_faultstate(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_2, HRTIM_OUTPUT_FAULTSTATE_NOACTIVE);
	(void)hrtim_timer_set_output_idlestate(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_2, HRTIM_OUTPUT_IDLESTATE_INACTIVE);
	(void)hrtim_timer_set_output_polarity(hdp, HRTIM_TIMER_F, HRTIM_TIMER_OUTPUT_2, HRTIM_OUTPUT_POLARITY_POSITIVE);
	(void)hrtim_ext_even_counter_cfg(hdp, HRTIM_TIMER_F, HRTIM_EVENT_NONE, HRTIM_EVENTCOUNTER_RSTMODE_UNCONDITIONAL, HRTIM_EVENT_NONE, 0x0);
	

	/* Common fault settings.*/

}

