/****************************************************************************
 *
 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
 *
 * License terms: STMicroelectronics Proprietary in accordance with licensing
 * terms SLA0098 at www.st.com.
 *
 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * DO NOT EDIT: Automatically generated file
 *****************************************************************************/

#include <dac_cfg.h>
#include <dma.h>
#include <irq.h>

/* Internal configuration data.*/

static dac_dma_conf_t ch2_config_dma_conf = {
	DMA1_STREAM0_ID,
	DMA_PRIORITY_MAX,
	IRQ_PRIORITY_10
};

/* Exported configuration APIs.*/

void dac_ch1_config(dac_driver_t *ddp) {

	/* Configure dac driver instance.*/
	(void)dac_set_mode(ddp, DAC_DRV_MODE_SINGLE);
	(void)dac_set_highfreq_mode(ddp, DAC_HF_MODE_OVER_160MHZ);
	(void)dac_set_format(ddp, DAC_CHANNEL_1, DAC_DATA_12BIT_RIGHT_ALIGN);
	(void)dac_set_output_connection(ddp, DAC_CHANNEL_1, DAC_OUT_CON_MODE_NORM_PIN_PER_BUF_EN);
	(void)dac_set_wave(ddp, DAC_CHANNEL_1, DAC_WAVE_MODE_DISABLE);
	(void)dac_set_dma_mode(ddp, DAC_CHANNEL_1, DAC_DMA_OFF);
	(void)dac_set_trigger_src(ddp, DAC_CHANNEL_1, DAC_SWTRIG);
	(void)dac_set_inc_trigger_src(ddp, DAC_CHANNEL_1, DAC_INC_SWTRIGB);
	(void)dac_set_rst_trigger_src(ddp, DAC_CHANNEL_1, DAC_RST_SWTRIGB);
	(void)dac_enable_channel(ddp, DAC_CHANNEL_1, true);
}

void dac_ch2_config(dac_driver_t *ddp) {

	/* Configure dac driver instance.*/
	(void)dac_set_mode(ddp, DAC_DRV_MODE_SINGLE);
	(void)dac_set_highfreq_mode(ddp, DAC_HF_MODE_OVER_160MHZ);
	(void)dac_set_format(ddp, DAC_CHANNEL_2, DAC_DATA_12BIT_RIGHT_ALIGN);
	(void)dac_set_output_connection(ddp, DAC_CHANNEL_2, DAC_OUT_CON_MODE_NORM_PIN_PER_BUF_EN);
	(void)dac_set_wave(ddp, DAC_CHANNEL_2, DAC_WAVE_MODE_DISABLE);
	(void)dac_set_dma_mode(ddp, DAC_CHANNEL_2, DAC_DMA_ON);
	dac_set_dma_conf(ddp, DAC_CHANNEL_2, &ch2_config_dma_conf);
	(void)dac_set_trigger_src(ddp, DAC_CHANNEL_2, DAC_CHx_TRIG2);
	(void)dac_enable_trigger(ddp, DAC_CHANNEL_2, true);
	(void)dac_set_inc_trigger_src(ddp, DAC_CHANNEL_2, DAC_INC_SWTRIGB);
	(void)dac_set_rst_trigger_src(ddp, DAC_CHANNEL_2, DAC_RST_SWTRIGB);
	(void)dac_enable_channel(ddp, DAC_CHANNEL_2, true);
}
