package com.st.stellar.component.sr5e1_wwdg.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_wwdg.Sr5e1_wwdg
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

class Sr5e1_wwdgCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}

	def String generateSr5e1_wwdgCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}

	def String generateSr5e1_wwdgCbfunc(Sr5e1_wwdg component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* These callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			if (!f.callback.isNullOrEmpty() && !cbfunc_list.contains(f.callback)) {
				res = res + '''

					void «f.callback»(wwdg_driver_t *wdp);
				'''
				cbfunc_list.add(f.callback)
			}
		}
		return res
	}
	
	def String generateSr5e1_wwdgExportedFunctions(Sr5e1_wwdg component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void wwdg_«f.name»(wwdg_driver_t *wdp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_wwdgHeader(Sr5e1_wwdg component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "wwdg_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_wwdgCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <wwdg.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_wwdgCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_wwdgExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_wwdgCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid WWDG Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}
	
	def String generateSr5e1_wwdgCode(Sr5e1_wwdg component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "wwdg_cfg"

		if (error.severity == Diagnostic.OK) {
			'''
				«generateSr5e1_wwdgCopyright()»

				#include <«filename».h>

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					
					void wwdg_«f.name»(wwdg_driver_t *wdp) {
					
						/* Configure wwdg driver instance.*/
						(void)wwdg_set_prio(wdp, «f.prio.getValue()»);
						(void)wwdg_set_prescaler(wdp, «f.presc.getName()»);
						(void)wwdg_set_counter(wdp, «f.counter»);
						(void)wwdg_set_window(wdp, «f.window»);
						«IF !f.callback.isNullOrEmpty()»
						(void)wwdg_set_is_ewk_irq_en(wdp, true);
						(void)wwdg_set_cb(wdp, «f.callback»);
						«ENDIF»
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
