package com.st.stellar.component.sr5e1_wwdg.validation

import com.st.stellar.component.sr5e1_wwdg.MSr5e1_wwdgPackage
import com.st.stellar.component.sr5e1_wwdg.Sr5e1_wwdg
import com.st.stellar.component.sr5e1_wwdg.util.Sr5e1_wwdgValidator
import java.io.File
import java.util.Map
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.common.util.DiagnosticChain
import org.eclipse.emf.ecore.EObject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.resources.IProject
import java.util.regex.Pattern
import com.st.stellar.component.sr5e1_wwdg.impl.Sr5e1_wwdgImpl
import com.st.stellar.component.sr5e1_wwdg.Configuration
import com.st.stellar.component.sr5e1_wwdg.impl.MConfigurationImpl

class MySr5e1_wwdgValidator extends Sr5e1_wwdgValidator {

	public static final MySr5e1_wwdgValidator INSTANCE = new MySr5e1_wwdgValidator();

	Sr5e1_wwdg currentComponent = null
	Configuration currentConfiguration = null

	static val ISSUE_CODE_PREFIX = "com.st.stellar.component.sr5e1_wwdg."

	static val WRONG_NAME = ISSUE_CODE_PREFIX + 'wrongName'
	static val WRONG_HEX = ISSUE_CODE_PREFIX + 'wrongHex'
	static val WRONG_CB = ISSUE_CODE_PREFIX + 'wrongcB'

	override validateConfiguration(Configuration configuration, DiagnosticChain diagnostics,
		Map<Object, Object> context) {
		currentComponent = configuration.eContainer as Sr5e1_wwdg
		currentConfiguration = configuration
		super.validateConfiguration(configuration, diagnostics, context)
	}

	override validateSr5e1_wwdg(Sr5e1_wwdg comp, DiagnosticChain diagnostics, Map<Object, Object> context) {
		currentComponent = comp
		val res = super.validateSr5e1_wwdg(comp, diagnostics, context)
		return res
	}

	override validatename_t_checkName(String nameToValidate, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_wwdgImpl
		if (parent === null) {
			return true
		}

		var res = checkName(nameToValidate, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_NAME, 0, "_UI_GenericConstraint_diagnostic",
						#["checkName", getValueLabel(MSr5e1_wwdgPackage.Literals.NAME_T, nameToValidate, context)],
						#[nameToValidate], context))
				res = false
			}
		}
		return res
	}

	static val WRONG_PATH = ISSUE_CODE_PREFIX + 'wrongPath'

	override validatePath_checkPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_wwdgImpl
		if (parent === null) {
			return true
		}

		var res = checkInputPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_wwdgPackage.Literals.PATH, path, context)], #[path], context))
				res = false
			}
		}
		return res
	}

	def checkInputPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true

		val project = getProject(comp)
		val fileName = project.getLocation().toOSString + File.separator + location
		val path = new Path(fileName)
		var res = false
		if (path.isValidPath(fileName)) {
			val file = new File(fileName)
			res = file.exists
		}
		res
	}

	
	public static val WRONG_GENPATH = ISSUE_CODE_PREFIX + 'wrongGenPath'

	override validategenpath_t_checkGenPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_wwdgImpl
		if (parent === null) {
			return true
		}

		var res = checkPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_GENPATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_wwdgPackage.Literals.GENPATH_T, path, context)], #[path],
						context))
				res = false
			}
		}
		return res
	}

	static val REGEX_NAME = Pattern.compile('''^[a-zA-Z]+[a-zA-Z0-9_]*$''')

	def checkName(String nameToValidate, DiagnosticChain chain, Map<Object, Object> map) {

		val parent = currentComponent as Sr5e1_wwdgImpl
		if (parent === null) {
			return true
		}

		val matches = REGEX_NAME.matcher(nameToValidate).matches
		if (!matches) {
			return false
		}

		// The name is syntactically correct... but may be already present in other configurations
		// Create the list of configuration names already present inside the Sr5e1_wwdg main object being validated
		// filter out current configuration (with its old name)
		var name_list = parent.configs.filter(c|c !== currentConfiguration).map[it|(it as MConfigurationImpl).name].
			toList
		if (name_list === null) {
			return true
		}

		// The new name must not be a duplicate
		val noDuplicates = (name_list.filter[it.equals(nameToValidate)].size < 1)
		noDuplicates
	}

	static val REGEX_PATH = Pattern.compile('''^[a-zA-Z0-9-_]+[a-zA-Z0-9-/\\_]*$''')

	def checkPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_PATH.matcher(location)
		var res = matcher.matches()
		res
	}
	
	override validatehex_t_checkHex(String hex_t, DiagnosticChain diagnostics, Map<Object, Object> context) {
		
		val parent = currentComponent as Sr5e1_wwdgImpl
		if (parent === null) {
			return true
		}
		
		var res = checkHex(hex_t, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_HEX, 0, "_UI_GenericConstraint_diagnostic",
						#["checkHex", getValueLabel(MSr5e1_wwdgPackage.Literals.HEX_T, hex_t, context)], #[hex_t],
						context))
				res = false
			}
		}
		return res
	}
	
	static val REGEX_HEX = Pattern.compile('''^0x[4-7][0-9A-Fa-f]$''')
	
	def checkHex(String hex, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_HEX.matcher(hex)
		var res = matcher.matches()
		res
	}
	
	override validatecallback_t_checkCb(String callback_t, DiagnosticChain diagnostics, Map<Object, Object> context) {
		
		val parent = currentComponent as Sr5e1_wwdgImpl
		if (parent === null) {
			return true
		}

		var res = checkCb(callback_t, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_CB, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_wwdgPackage.Literals.CALLBACK_T, callback_t, context)], #[callback_t],
						context))
				res = false
			}
		}
		return res
	}
	
	static val REGEX_CB = Pattern.compile('''^([a-zA-Z][a-zA-Z0-9_-]*)?$''')

	def checkCb(String cb, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_CB.matcher(cb)
		var res = matcher.matches()
		res
	}

	static def IProject getProject(EObject model) {
		val uri = model.eResource.URI
		val projectName = uri.segmentsList().get(1).toString()
		return ResourcesPlugin.workspace.root.getProject(projectName)
	}
}
