package com.st.stellar.component.sr5e1_uart.impl

import com.st.stellar.component.sr5e1_uart.Configuration
import com.st.stellar.component.sr5e1_uart.MSr5e1_uartPackage
import com.st.stellar.component.sr5e1_uart.Sr5e1_uart
import com.st.stellar.component.sr5e1_uart.util.Sr5e1_uartValidator
import java.util.Map
import java.util.regex.Pattern
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.common.util.DiagnosticChain

class MySr5e1_uartValidator extends Sr5e1_uartValidator {

	public static final MySr5e1_uartValidator INSTANCE = new MySr5e1_uartValidator();

	static val ISSUE_CODE_PREFIX = "com.st.stellar.component.sr5e1_uart."

	static val WRONG_NAME = ISSUE_CODE_PREFIX + 'wrongName'

	Sr5e1_uart currentComponent = null
	Configuration currentConfiguration = null

	override validateConfiguration(Configuration configuration, DiagnosticChain diagnostics,
		Map<Object, Object> context) {
		currentComponent = configuration.eContainer as Sr5e1_uart
		currentConfiguration = configuration
		super.validateConfiguration(configuration, diagnostics, context)
	}

	override validatename_t_checkName(String nameToValidate, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_uartImpl
		if (parent === null) {
			return true
		}

		var res = checkName(nameToValidate, diagnostics, context)

		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_NAME, 0, "_UI_GenericConstraint_diagnostic",
						#["checkName", getValueLabel(MSr5e1_uartPackage.Literals.PATH_T, nameToValidate, context)],
						#[nameToValidate], context))
				res = false
			}
		}
		return res
	}
	
	override validateUINT32_T_checkUINT32_T(Long uint32_T, DiagnosticChain diagnostics, Map<Object, Object> context) {
		
		val parent = currentComponent as Sr5e1_uartImpl
		if (parent === null) {
			return true
		}
		
		if (uint32_T >= 0 && uint32_T <= 4294967295L){
			return true
		} else {
			return false
		}
	}

	public static val WRONG_PATH = ISSUE_CODE_PREFIX + 'wrongPath'

	override validatepath_t_checkPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_uartImpl
		if (parent === null) {
			return true
		}

		var res = checkPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_uartPackage.Literals.PATH_T, path, context)], #[path],
						context))
				res = false
			}
		}
		return res
	}

	override validatecallback_t_check_cb(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_uartImpl
		if (parent === null) {
			return true
		}

		var res = checkCb(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_uartPackage.Literals.PATH_T, path, context)], #[path],
						context))
				res = false
			}
		}
		return res
	}

	static val REGEX_NAME = Pattern.compile('''^[a-zA-Z]+[a-zA-Z0-9_]*$''')

	def checkName(String nameToValidate, DiagnosticChain chain, Map<Object, Object> map) {

		val comp = currentComponent
		val parent = currentComponent as Sr5e1_uartImpl
		if (parent === null) {
			return true
		}

		val matches = REGEX_NAME.matcher(nameToValidate).matches
		if (!matches) {
			return false
		}

		// The name is syntactically correct... but may be already present in other configurations
		// Create the list of configuration names already present inside the Sr5e1 main object being validated
		// filter out current configuration (with its old name)
		var name_list = parent.configs.filter(c|c !== currentConfiguration).map[it|(it as MConfigurationImpl).name].
			toList
		if (name_list === null) {
			return true
		}

		// The new name must not be a duplicate
		var noDuplicates = (name_list.filter[it.equals(nameToValidate)].size < 1)
		if(comp === null) return true
		noDuplicates
	}

	static val REGEX_PATH = Pattern.compile('''^[a-zA-Z0-9-_]+[a-zA-Z0-9-/\\_]*$''')

	def checkPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_PATH.matcher(location)
		var res = matcher.matches()
		res
	}

	static val REGEX_CB = Pattern.compile('''^([a-zA-Z][a-zA-Z0-9_-]*)?$''')

	def checkCb(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_CB.matcher(location)
		var res = matcher.matches()
		res
	}
}
