package com.st.stellar.component.sr5e1_uart.impl

import com.st.stellar.component.sr5e1_uart.Sr5e1_uart
import com.st.stellar.component.sr5e1_uart.rx_drv_mod_t
import com.st.stellar.component.sr5e1_uart.tx_drv_mod_t
import java.util.Locale
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext

class Sr5e1_uartCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}

	def String generateSr5e1_uartcbfunc(Sr5e1_uart component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* This callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			if (!f.transmit_callback.isNullOrEmpty() && !cbfunc_list.contains(f.transmit_callback)) {
				res = res + '''

					void «f.transmit_callback»(uart_driver_t *udp);
				'''
				cbfunc_list.add(f.transmit_callback)
			}
			if (!f.receive_callback.isNullOrEmpty() && !cbfunc_list.contains(f.receive_callback)) {
				res = res + '''

					void «f.receive_callback»(uart_driver_t *udp);
				'''
				cbfunc_list.add(f.receive_callback)
			}
			if (!f.error_callback.isNullOrEmpty() && !cbfunc_list.contains(f.error_callback)) {
				res = res + '''

					void «f.error_callback»(uart_driver_t *udp);
				'''
				cbfunc_list.add(f.error_callback)
			}
			if (!f.parity_error_callback.isNullOrEmpty() && !cbfunc_list.contains(f.parity_error_callback)) {
				res = res + '''

					void «f.parity_error_callback»(uart_driver_t *udp);
				'''
				cbfunc_list.add(f.parity_error_callback)
			}
		}

		return res
	}

	def String generateSr5e1_uartExportedFunctions(Sr5e1_uart component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void «f.name»(uart_driver_t *udp);
			'''
		}
		header2
	}

	def String generateSr5e1_uartCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}

	def String generateSr5e1_uartHeader(Sr5e1_uart component) {

		val error = Diagnostician.INSTANCE.validate(component)

		//val filename = component.name
		val filename = "uart_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_uartCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <uart.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_uartcbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_uartExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_uartCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid UART Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}

	def String generateSr5e1_uartdata(Sr5e1_uart component) {
		var res = ""

		for (f : component.configs.filter[enabled]) {
			if (f.rx_driver_mode == rx_drv_mod_t.UART_RX_DRV_MODE_DMA_SYNC || f.rx_driver_mode == rx_drv_mod_t.UART_RX_DRV_MODE_DMA_ASYNC || 
				f.tx_driver_mode == tx_drv_mod_t.UART_TX_DRV_MODE_DMA_SYNC || f.tx_driver_mode == tx_drv_mod_t.UART_TX_DRV_MODE_DMA_ASYNC) {
				res = res + '''

				static uart_dma_conf_t «f.name»_dma_conf = {
					«f.dma_stream_tx_id.getName()»,
					«f.dma_stream_rx_id.getName()»,
					«f.dma_stream_bus_priority.getName()»,
					«f.dma_stream_irq_priority.getName()»
				};'''
			}

			if (f.rx_driver_mode == rx_drv_mod_t.UART_RX_DRV_MODE_INT_BUFF_SYNC) {

				res = res + '''

				static uint8_t «f.name»_«f.buffer_name»[«f.buffer_size»] = {0};
				'''
			}
		}
		return (res)

	}

	def String generateSr5e1_uartCode(Sr5e1_uart component) {

		val error = Diagnostician.INSTANCE.validate(component)

		//val filename = component.name
		val filename = "uart_cfg"
		var is_dma_enable = false

		if (error.severity == Diagnostic.OK) {
			for ( f : component.configs.filter[enabled]) {
				if (f.rx_driver_mode == rx_drv_mod_t.UART_RX_DRV_MODE_DMA_SYNC || f.rx_driver_mode == rx_drv_mod_t.UART_RX_DRV_MODE_DMA_ASYNC || 
			    	f.tx_driver_mode == tx_drv_mod_t.UART_TX_DRV_MODE_DMA_SYNC || f.tx_driver_mode == tx_drv_mod_t.UART_TX_DRV_MODE_DMA_ASYNC) {
			    		is_dma_enable = true;
			    }
			}
			'''
				«generateSr5e1_uartCopyright()»

				#include <«filename».h>
				«IF (is_dma_enable == true)»
				#include <dma.h>
				«ENDIF»
				#include <irq.h>
				
				/* Internal configuration data.*/
				«generateSr5e1_uartdata(component)»


				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					
					void «f.name»(uart_driver_t *udp) {
					
						/* Configure UART driver instance.*/
						(void)uart_set_prio(udp, «f.interrupt_priority.getName()»);
						(void)uart_set_rx_drv_mode(udp, «f.rx_driver_mode.getName»);
						(void)uart_set_tx_drv_mode(udp, «f.tx_driver_mode.getName»);
						«IF (f.rx_driver_mode == rx_drv_mod_t.UART_RX_DRV_MODE_DMA_SYNC || f.rx_driver_mode == rx_drv_mod_t.UART_RX_DRV_MODE_DMA_ASYNC || 
						     f.tx_driver_mode == tx_drv_mod_t.UART_TX_DRV_MODE_DMA_SYNC || f.tx_driver_mode == tx_drv_mod_t.UART_TX_DRV_MODE_DMA_ASYNC)»
						uart_set_dma_conf(udp, «'&'+f.name+'_dma_conf'»);
						«ENDIF»
						«IF (f.rx_driver_mode == rx_drv_mod_t.UART_RX_DRV_MODE_INT_BUFF_SYNC)»
						uart_set_sbrx_buf(udp, «f.name+'_'+f.buffer_name», «f.buffer_size»);
						«ENDIF»
						«IF (f.fifo)»
						(void)uart_set_fifo_enable(udp, true);
						uart_set_fifo_threshold(udp, «f.rx_fifo_threshold.getName», «f.tx_fifo_threshold.getName»);
						«ELSE»
						(void)uart_set_fifo_enable(udp, false);
						«ENDIF»
						(void)uart_set_baud(udp, «f.baudrate.getName()»);
						(void)uart_set_presc(udp, «f.prescaler.getName()»);
						(void)uart_set_parity(udp, «f.parity.getName()»);
						(void)uart_set_over(udp, «f.oversampling.getName()»);
						(void)uart_set_sbit(udp, «f.stop_bits.getName()»);
						«IF (f.idle_en)»
						(void)uart_set_idle_enable(udp, true);
						«ENDIF»
						«IF (f.timeout != 0)»
						(void)uart_set_timeout(udp, «f.timeout»);
						«ENDIF»
						«IF (!f.transmit_callback.isNullOrEmpty())»
						(void)uart_set_cb(udp, UART_CB_OPS_TX, «f.transmit_callback»);
						«ENDIF»
						«IF (!f.receive_callback.isNullOrEmpty())»
						(void)uart_set_cb(udp, UART_CB_OPS_RX, «f.receive_callback»);
						«ENDIF»
						«IF (!f.error_callback.isNullOrEmpty())»
						(void)uart_set_cb(udp, UART_CB_OPS_ERR, «f.error_callback»);
						«ENDIF»
						«IF (!f.parity_error_callback.isNullOrEmpty())»
						(void)uart_set_cb(udp, UART_CB_OPS_PERR, «f.parity_error_callback»);
						«ENDIF»
					}
				«ENDFOR»
			'''

		} else {
			'''
				«generateSr5e1_uartCopyright()»
				#include <«filename».h>
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
