package com.st.stellar.component.sr5e1_tim.impl

import com.st.stellar.component.sr5e1_tim.Ch_cfg
import com.st.stellar.component.sr5e1_tim.Ch_cfg_common
import com.st.stellar.component.sr5e1_tim.Sr5e1_tim
import java.util.Locale
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext

class Sr5e1_timCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}
	
	def String generateSr5e1_timCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}
	
	def String generateSr5e1_timCbfunc(Sr5e1_tim component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* These callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			if (f.callbacks.length > 0){
				for (callback : f.callbacks){
					if (!cbfunc_list.contains(callback) && (callback.toString.length > 0)) {
						res += '''
							void «callback.callback»(tim_driver_t *tdp);
						'''
						cbfunc_list.add(callback);	
					}
	 			}
			}
		}

		return res
	}
	
	def String generateSr5e1_timExportedFunctions(Sr5e1_tim component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void tim_«f.name»(tim_driver_t *tdp);
			'''
		}
		header2
	}
	
	def String generateChannelCode(Ch_cfg channel, int channel_id) {
		var code = ""
		
		code += '''
			«IF (channel.enable == true)»
			
			/* Configure channel «channel_id».*/
			(void)tim_set_ic_filter(tdp, «channel_id», «channel.input_capture_filter.getName()»);
			(void)tim_set_ch_mode(tdp, «channel_id», «channel.mode.getName()»);
			«IF (channel.dma_en == true)»
			
			tim_dma_conf_t ch«channel_id»_dma_conf = {«channel.dma_stream_id.getName()»,
									   «channel.dma_stream_bus_prio.getName()»,
									   «channel.dma_stream_irq_prio.getName()»
									   };
			tim_set_dma_conf(tdp, TIM_DMA_OPS_CH«channel_id», &ch«channel_id»_dma_conf);
			«ENDIF»
			«ENDIF»
			
		'''
		
		code
	}
	
	def String generateChannel_56Code(Ch_cfg_common channel, int channel_id) {
		var code = ""
		
		code += '''
			«IF (channel.enable == true)»
			
			/* Configure channel «channel_id».*/
			(void)tim_set_ic_filter(tdp, «channel_id», «channel.input_capture_filter.getName()»);
			(void)tim_set_ch_mode(tdp, «channel_id», «channel.mode.getName()»);
			«ENDIF»
			
		'''
		
		code
	}

	def String generateSr5e1_timHeader(Sr5e1_tim component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "tim_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_timCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <tim.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_timCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_timExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_timCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid TIM Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}	
	
	def String generateSr5e1_timCode(Sr5e1_tim component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "tim_cfg"

		if (error.severity == Diagnostic.OK) {
			'''
				«generateSr5e1_timCopyright()»

				#include <«filename».h>
				#include <dma.h>

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					void tim_«f.name»(tim_driver_t *tdp) {
						
						/* Configure tim driver instance.*/
						(void)tim_set_prio(tdp, «f.priority.getName()»);
						(void)tim_set_presc(tdp, «f.prescaler»);
						(void)tim_enable_opm(tdp, «f.one_pulse_mode.getValue()»);
						(void)tim_set_ckd(tdp, «f.clock_division.getName()»);
						(void)tim_set_cms(tdp, «f.center_aligned_mode.getName()»);
						(void)tim_set_dt(tdp, «f.rising_edge_deadtime», «f.falling_edge_deadtime»);
						«IF (f.instance.getValue() > 0)»
						«generateChannelCode(f.channel1, 1)»
						«ENDIF»
						«IF (f.instance.getValue() > 1)»
						«generateChannelCode(f.channel2, 2)»
						«ENDIF»
						«IF (f.instance.getValue() > 2)»
						«generateChannelCode(f.channel3, 3)»
						«ENDIF»
						«IF (f.instance.getValue() > 3)»
						«generateChannelCode(f.channel4, 4)»
						«ENDIF»
						«IF (f.instance.getValue() > 4)»
						«generateChannel_56Code(f.channel5, 5)»
						«ENDIF»
						«IF (f.instance.getValue() > 5)»
						«generateChannel_56Code(f.channel6, 6)»
						«ENDIF»
						(void)tim_set_trgo(tdp, «f.trigger_output.getName()»);
						(void)tim_set_trgo2(tdp, «f.trigger_output2.getName()»);
						
						(void)tim_set_sms(tdp, «f.slave_mode_selection.getName()»);
						
						(void)tim_set_trgi(tdp, «f.trigger_input.getName()»);
						
						/* Configure external trigger.*/
						(void)tim_set_etf(tdp, «f.external_trigger_filter»);
						(void)tim_set_etps(tdp, «f.external_trigger_prescaler.getName()»);
						(void)tim_set_etp(tdp, «f.external_trigger_polarity.getName()»);
						
						«IF (f.break_event1.break_event.getValue() == 1)»
						(void)tim_set_bk(tdp, «f.break_event1.break_event_polarity.getName()»);
						«ENDIF»
						«IF (f.break_event2.break_event.getValue() == 1)»
						(void)tim_set_bk2(tdp, «f.break_event2.break_event_polarity.getName()»);
						«ENDIF»
						
						(void)tim_set_ti1_selection(tdp, «f.input_selection.getName()»);
						(void)tim_enable_preload_control(tdp, «f.preload_control.getValue()»);
						«IF (f.dma_en == true)»
						
						tim_dma_conf_t update_dma_conf = {«f.dma_stream_id.getName()»,
												   «f.dma_stream_bus_prio.getName()»,
												   «f.dma_stream_irq_prio.getName()»
												   };
						tim_set_dma_conf(tdp, TIM_DMA_OPS_UPDATE, &update_dma_conf);
						«ENDIF»
						
						«IF (f.callbacks.length > 0)»
						/* Configure callbacks.*/
						«FOR cb : f.callbacks»
						«IF (!cb.callback.isNullOrEmpty())»
						(void)tim_set_cb(tdp, «cb.operation.getName()», «cb.callback»);
						«ENDIF»
						«ENDFOR»
						«ENDIF»
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
