package com.st.stellar.component.sr5e1_tim.impl

import com.st.stellar.component.sr5e1_tim.Ch_cfg_common
import com.st.stellar.component.sr5e1_tim.Configuration

// This class overrides the generated class and will be instantiated by factory
class Ch_cfg_commonImpl extends MCh_cfg_commonImpl implements Ch_cfg_common
{

static val int[] CHANNELS_ENABLE = #[
		6, 4, 4, 4, 4, 0, 0, 6, 0, 0, 0, 0, 0, 0, 2, 1
	]
	
	override isInstanceEnabled() {
		
		val configuration = this.eContainer as Configuration
		if (configuration !== null) {
			
			// Look for all references with name starting with channel
			for (element : configuration.eClass.EAllReferences) {
				if (element.name.startsWith("channel")) {
					val elt = configuration.eGet(element)

					// We are interested in particular with the one being manipulated (this object)
					if (elt.equals(this)) {
						// Get channel number
						val strIndex = element.name.replace("channel", "")
						val channelNumber = Integer.parseInt(strIndex) - 1
						
						// Get TIM instance number from configuration
						val instance = configuration.instance
						val instanceIndex = Integer.parseInt(instance.name().replace("TIM", "")) - 1
						
						// return the enablement state from the static array of enabled instances
						val en = channelNumber < CHANNELS_ENABLE.get(instanceIndex)
						return en
					}
				}
			}
		}
		super.isInstanceEnabled
	}
}
