package com.st.stellar.component.sr5e1_spi.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_spi.Sr5e1_spi
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

import com.st.stellar.component.sr5e1_spi.drv_mode_t
import com.st.stellar.component.sr5e1_spi.mode_t
import com.st.stellar.component.sr5e1_spi.nss_mode_t

class Sr5e1_spiCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}
	
	def String generateSr5e1_spiCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}
	
	def String generateSr5e1_spiCbfunc(Sr5e1_spi component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* This callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			if (!f.data_callback.isNullOrEmpty() && !cbfunc_list.contains(f.data_callback)) {
				res = res + '''

					void «f.data_callback»(spi_driver_t *sdp);
				'''
				cbfunc_list.add(f.data_callback)
			}
			if (!f.error_callback.isNullOrEmpty() && !cbfunc_list.contains(f.error_callback)) {
				res = res + '''

					void «f.error_callback»(spi_driver_t *sdp);
				'''
				cbfunc_list.add(f.error_callback)
			}
			if (!f.crc_error_callback.isNullOrEmpty() && !cbfunc_list.contains(f.crc_error_callback)) {
				res = res + '''

					void «f.crc_error_callback»(spi_driver_t *sdp);
				'''
				cbfunc_list.add(f.crc_error_callback)
			}
		}

		return res
	}
	
	def String generateSr5e1_spiExportedFunctions(Sr5e1_spi component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void spi_«f.name»(spi_driver_t *sdp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_spiHeader(Sr5e1_spi component) {

		val error = Diagnostician.INSTANCE.validate(component)

		//val filename = component.name
		val filename = "spi_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_spiCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <spi.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_spiCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_spiExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_spiCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid SPI Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}
	
	def String generateSr5e1_spidata(Sr5e1_spi component) {
		var res = ""

		for (f : component.configs.filter[enabled]) {
			if (f.driver_mode == drv_mode_t.SPI_DRV_MODE_DMA_SYNC || f.driver_mode == drv_mode_t.SPI_DRV_MODE_DMA_ASYNC) {
				res = res + '''

				static spi_dma_conf_t «f.name»_dma_conf = {
					«f.dma_stream_rx_id.getName()»,
					«f.dma_stream_tx_id.getName()»,
					«f.dma_stream_bus_priority.getName()»,
					«f.dma_stream_irq_priority.getName()»
				};'''
			}
		}
		return (res)

	}
	
	def String generateSr5e1_spiCode(Sr5e1_spi component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "spi_cfg"
		var is_dma_enable = false

		if (error.severity == Diagnostic.OK) {
			for ( f : component.configs.filter[enabled]) {
				if (f.driver_mode == drv_mode_t.SPI_DRV_MODE_DMA_SYNC || f.driver_mode == drv_mode_t.SPI_DRV_MODE_DMA_ASYNC) {
			    		is_dma_enable = true;
			    }
			}
			'''
				«generateSr5e1_spiCopyright()»

				#include <«filename».h>
				«IF (is_dma_enable == true)»
				#include <dma.h>
				«ENDIF»
				#include <irq.h>
				
				/* Internal configuration data.*/
				«generateSr5e1_spidata(component)»

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					
					void spi_«f.name»(spi_driver_t *sdp) {
					
						/* Configure spi driver instance.*/
						(void)spi_set_mode(sdp, «f.mode.getName()»);
						«IF (f.mode == mode_t.SPI_MODE_MASTER)»
						(void)spi_set_nssp_mode(sdp, «f.NSS_pulse.getName()»);
						(void)spi_set_nss_mode(sdp, «f.NSS_mode.getName()»);
						«ENDIF»
						«IF (f.crc_en == true)»
						(void)spi_set_crc_enable(sdp, true);
						(void)spi_set_crc_poly(sdp, «f.crc_poly.getName()»);
						«ENDIF»
						(void)spi_set_drv_mode(sdp, «f.driver_mode.getName()»);
						«IF (f.driver_mode == drv_mode_t.SPI_DRV_MODE_DMA_SYNC || f.driver_mode == drv_mode_t.SPI_DRV_MODE_DMA_ASYNC)»
						spi_set_dma_conf(sdp, «'&'+f.name+'_dma_conf'»);
						«ENDIF»
						(void)spi_set_cmode(sdp, «f.communication_mode.getName()»);
						(void)spi_set_baud(sdp, «f.baudrate.getName()»);
						(void)spi_set_fformat(sdp, «f.frame_format.getName()»);
						(void)spi_set_fsize(sdp, «f.frame_size.getName()»);
						(void)spi_set_cpha(sdp, «f.data_capture_edge.getName()»);
						(void)spi_set_cpol(sdp, «f.clock_idle_state.getName()»);
						«IF (f.timeout != 0)»
						(void)spi_set_timeout(sdp, «f.timeout»);
						«ENDIF»
						«IF (!f.data_callback.isNullOrEmpty())»
						(void)spi_set_cb(sdp, SPI_CB_OPS_DONE, «f.data_callback»);
						«ENDIF»
						«IF (!f.error_callback.isNullOrEmpty())»
						(void)spi_set_cb(sdp, SPI_CB_OPS_ERR, «f.error_callback»);
						«ENDIF»
					«IF (!f.crc_error_callback.isNullOrEmpty())»
					    (void)spi_set_cb(sdp, SPI_CB_CRC_ERR, «f.crc_error_callback»);
					«ENDIF»
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
