package com.st.stellar.component.sr5e1_spi.impl;

import com.st.stellar.component.model.DerivedAttributeService
import com.st.stellar.component.sr5e1_spi.Configuration
import com.st.stellar.component.sr5e1_spi.Sr5e1_spiPackage
import org.eclipse.core.resources.IProject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.IPath
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.command.Command
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EDataType
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.edit.command.SetCommand
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain
import org.eclipse.swt.widgets.DirectoryDialog
import org.eclipse.swt.widgets.Display

// This class overrides the generated class and will be instantiated by factory
class ConfigurationImpl extends MConfigurationImpl implements Configuration
{
	
	override getName() {
		if (name.isNullOrEmpty) {
			val parent = eContainer as Sr5e1_spiImpl
			name = parent.createName
		}
		name
	}
	
	static def IProject getProject(EObject model) {
		var IProject project = null
		val uri = model.eResource().getURI();
		if (!uri.isFile()) {
			project = null;
		}
		val projectName = uri.segmentsList().get(1).toString()
		project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		return project;
	}
	
	def setAttributeValue(EObject object, EAttribute attribute, String value) {
		val editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(object)

		val eClassifier = attribute.EType
		if (eClassifier instanceof EDataType) {
			val eDataType = eClassifier as EDataType
			val eFactory = eDataType.getEPackage().getEFactoryInstance()
			val newValue = eFactory.createFromString(eDataType, value)
			val Command command = SetCommand.create(editingDomain, object, attribute,
				newValue);
			// System.out.println("Attribute '" + attribute.getName() + "' set to " + newValue.toString());
			editingDomain.getCommandStack().execute(command);
		}
	}
	

}
