package com.st.stellar.component.sr5e1_sdadc.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_sdadc.Sr5e1_sdadc
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

import com.st.stellar.component.sr5e1_sdadc.mode_t

class Sr5e1_sdadcCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}
	
	def String generateSr5e1_sdadcCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}

	def String generateSr5e1_sdadcCbfunc(Sr5e1_sdadc component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* These callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			if (!f.fifo_full_cb.isNullOrEmpty() && !cbfunc_list.contains(f.fifo_full_cb)) {
				res = res + '''

					void «f.fifo_full_cb»(sdadc_driver_t *sdp);
				'''
				cbfunc_list.add(f.fifo_full_cb)
			}
			if (!f.fifo_overrun_cb.isNullOrEmpty() && !cbfunc_list.contains(f.fifo_overrun_cb)) {
				res = res + '''

					void «f.fifo_overrun_cb»(sdadc_driver_t *sdp);
				'''
				cbfunc_list.add(f.fifo_overrun_cb)
			}
			if (!f.watchdog_cb.isNullOrEmpty() && !cbfunc_list.contains(f.watchdog_cb)) {
				res = res + '''

					void «f.watchdog_cb»(sdadc_driver_t *sdp);
				'''
				cbfunc_list.add(f.watchdog_cb)
			}
		}
		return res
	}
	
	def String generateSr5e1_sdadcExportedFunctions(Sr5e1_sdadc component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void sdadc_«f.name»(sdadc_driver_t *sdp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_sdadcHeader(Sr5e1_sdadc component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "sdadc_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_sdadcCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <sdadc.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_sdadcCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_sdadcExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_sdadcCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid SDADC Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}
	
	def String generateSr5e1_sdadcCode(Sr5e1_sdadc component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "sdadc_cfg"

		if (error.severity == Diagnostic.OK) {
			'''
				«generateSr5e1_sdadcCopyright()»

				#include <«filename».h>
				#include <irq.h>

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					
					void sdadc_«f.name»(sdadc_driver_t *sdp) {
					
						/* Configure sdadc driver instance.*/
						(void)sdadc_set_prio(sdp, «f.prio.getName()»);
						(void)sdadc_set_ground(sdp, «f.ground»);
						(void)sdadc_set_voltage(sdp, «f.voltage»);
						(void)sdadc_set_calibration(sdp, «f.calibration.getName()»);
						(void)sdadc_set_mode(sdp, «f.mode.getName()»);
						«IF f.mode == mode_t.SDADC_MODE_SINGLE_ENDED_INPUT»
						(void)sdadc_set_common_bias(sdp, «f.bias.getName()»);
						«ENDIF»
						(void)sdadc_set_channel(sdp, «f.anchsel.getName()»);
						(void)sdadc_set_pdr(sdp, «f.pdr.getName()»);
						(void)sdadc_set_pgain(sdp, «f.pgain.getName()»);
						«IF f.highpass_en == true»
						(void)sdadc_enable_highpass(sdp);
						«ENDIF»
						«IF f.bias_en == true»
						(void)sdadc_enable_bias(sdp);
						«ENDIF»
						(void)sdadc_set_osd(sdp, «f.osd»);
						«IF f.fifo_ow_en == true»
						(void)sdadc_enable_fifo_overwrite(sdp);
						«ENDIF»
						«IF f.trg_en == true»
						(void)sdadc_enable_trigger(sdp, «f.trg_sel.getName()», «f.trg_edge.getName()»);
						«ENDIF»
						«IF f.timestamp_en == true»
						(void)sdadc_enable_timestamp(sdp);
						«ENDIF»
						«IF (!f.fifo_full_cb.isNullOrEmpty())»
						(void)sdadc_enable_fifo_full_event(sdp, «f.fifo_th», «f.fifo_full_cb»);
						«ENDIF»
						«IF (!f.fifo_overrun_cb.isNullOrEmpty())»
						(void)sdadc_enable_fifo_overrun_event(sdp, «f.fifo_overrun_cb»);
						«ENDIF»
						«IF (!f.watchdog_cb.isNullOrEmpty())»
						(void)sdadc_enable_watchdog_event(sdp, «f.wd_low», «f.wd_high», «f.watchdog_cb»);
						«ENDIF»
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
