package com.st.stellar.component.sr5e1_sdadc.editor;

import com.st.stellar.component.model.ui.ComponentValidationLabelDecoratorProvider
import com.st.stellar.component.model.ui.ComponentValidationServiceLabelDecorator
import com.st.stellar.component.sr5e1_sdadc.Sr5e1_sdadc
import org.eclipse.emf.common.notify.Notifier
import org.eclipse.emf.ecore.EObject
import org.eclipse.emfforms.common.Optional
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache
import org.eclipse.jface.viewers.ILabelDecorator
import org.eclipse.jface.viewers.TreeViewer

class Sr5e1_sdadcLabelDecoratorProvider extends ComponentValidationLabelDecoratorProvider {

	new(Notifier input) {
		super(input)
	}

	override Optional<ILabelDecorator> getLabelDecorator(TreeViewer viewer) {
		decorator = new MyLabelServiceDecorator(viewer, input, cache)
		return Optional.<ILabelDecorator>of(decorator)
	}
}

class MyLabelServiceDecorator extends ComponentValidationServiceLabelDecorator {

	new(TreeViewer viewer, Notifier input, DiagnosticCache cache) {
		super(viewer, input, cache)
	}

	override String decorateText(String text, Object element) {
	    return this.format(element, text);
	}

	dispatch def format(Sr5e1_sdadc object, String text
	) {
		return object.name
	}

	dispatch def format(EObject object, String text) {
		return text
	}

	dispatch def format(Object object, String text) {
		return text
	}

}
