package com.st.stellar.component.sr5e1_saradc.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_saradc.Sr5e1_saradc
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

import com.st.stellar.component.sr5e1_saradc.ext_pol_t

class Sr5e1_saradcCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}
	
	def String generateSr5e1_saradcCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}
	
	def String generateSr5e1_saradcExpData(Sr5e1_saradc component) {
		var res = ""
		
		for (f : component.configs.filter[enabled]) {
			res = res + '''
			«IF (f.regular_conversion_enabled == true && f.enable_dma == true)»
			/* Regular conversions data buffer.*/
			extern adc_sample_t «f.reg_buffer»[«f.regular_channels.length()»];
			
			/* Regular conversions sequence.*/
			extern uint8_t «f.name»_reg_seq[«f.regular_channels.length()»];
			«ENDIF»
			«IF (f.injected_conversion_enabled == true)»
			/* Injected conversions DMA configuration.*/
			extern adc_sample_t «f.inj_buffer»[«f.injected_channels.length()»];
			/* Injected conversions sequence.*/
			extern uint8_t «f.name»_inj_seq[«f.injected_channels.length()»];
			«ENDIF»
			«IF (f.dual_mode_enabled == true)»
			/* Dual mode conversions data buffer.*/
			extern uint32_t «f.dual_buffer»[«f.regular_channels.length()»];
			«ENDIF»
			'''
		}
		return res
	}
	
	def String generateSr5e1_saradcCbfunc(Sr5e1_saradc component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* These callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			/* DMA error callback */
			if (!f.dma_error_cb.isNullOrEmpty() && !cbfunc_list.contains(f.dma_error_cb)) {
				res = res + '''

					void «f.dma_error_cb»(adc_driver_t *adp, adc_err_t err);
				'''
				cbfunc_list.add(f.dma_error_cb)
			}
			/* Regular conversion callback */
			if (!f.regular_conversions_callback.isNullOrEmpty() && !cbfunc_list.contains(f.regular_conversions_callback)) {
				res = res + '''

					void «f.regular_conversions_callback»(adc_driver_t *adp);
				'''
				cbfunc_list.add(f.regular_conversions_callback)
			}
			/* Injected conversion callback */
			if (!f.injected_conversions_callback.isNullOrEmpty() && !cbfunc_list.contains(f.injected_conversions_callback)) {
				res = res + '''

					void «f.injected_conversions_callback»(adc_driver_t *adp);
				'''
				cbfunc_list.add(f.injected_conversions_callback)
			}
			/* Dual mode conversion callback */
			if (!f.dual_mode_callback.isNullOrEmpty() && !cbfunc_list.contains(f.dual_mode_callback)) {
				res = res + '''

					void «f.dual_mode_callback»(adc_driver_t *adp);
				'''
				cbfunc_list.add(f.dual_mode_callback)
			}
			
			/* Watchdog callback 1 */
			if (!f.aw_1_callback.isNullOrEmpty() && !cbfunc_list.contains(f.aw_1_callback)) {
				res = res + '''

					void «f.aw_1_callback»(adc_driver_t *adp, adc_err_t err);
				'''
				cbfunc_list.add(f.aw_1_callback)
			}
			/* Watchdog callback 2 */
			if (!f.aw_2_callback.isNullOrEmpty() && !cbfunc_list.contains(f.aw_2_callback)) {
				res = res + '''

					void «f.aw_2_callback»(adc_driver_t *adp, adc_err_t err);
				'''
				cbfunc_list.add(f.aw_2_callback)
			}
			/* Watchdog callback 3 */
			if (!f.aw_3_callback.isNullOrEmpty() && !cbfunc_list.contains(f.aw_3_callback)) {
				res = res + '''

					void «f.aw_3_callback»(adc_driver_t *adp, adc_err_t err);
				'''
				cbfunc_list.add(f.aw_3_callback)
			}
		}

		return res
	}
	
	def String generateSr5e1_saradcExportedFunctions(Sr5e1_saradc component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void adc_«f.name»(adc_driver_t *adp);
			'''
		}
		header2
	}

	def String generateSr5e1_saradcHeader(Sr5e1_saradc component) {

		val error = Diagnostician.INSTANCE.validate(component)

		//val filename = component.name
		val filename = "saradc_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_saradcCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <saradc.h>

				#ifdef __cplusplus
				extern "C" {
				#endif
				
				/* Exported data.*/
				«generateSr5e1_saradcExpData(component)»

				/* Exported callback function prototypes.*/
				«generateSr5e1_saradcCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_saradcExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_saradcCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid SARADC Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}
	
	def String generateSr5e1_saradcdata(Sr5e1_saradc component) {
		var res = ""

		for (f : component.configs.filter[enabled]) {
			
			res = res + '''
			«IF (f.regular_conversion_enabled == true)»
			«IF (f.enable_dma == true)»
			/* Regular conversions DMA configuration.*/
			static adc_dma_conf_t «f.name»_reg_dma_conf = {
				«f.dma_stream_id.getName()»,
				«f.dma_stream_bus_priority.getName()»,
				«f.dma_stream_irq_priority.getName()»
				};
			
			/* Regular conversions data buffer.*/
			adc_sample_t «f.reg_buffer»[«f.regular_channels.length()»];
			«ENDIF»
			
			/* Regular conversion sequence.*/
			uint8_t «f.name»_reg_seq[«f.regular_channels.length()»] = {
			«FOR row : f.regular_channels»
			«row.ch.getName()»,
			«ENDFOR»
			};
			«ENDIF»
			«IF (f.injected_conversion_enabled == true)»
			
			/* Injected conversions DMA configuration.*/
			adc_sample_t «f.inj_buffer»[«f.injected_channels.length()»];
			
			/* Injected conversion sequence.*/
			uint8_t «f.name»_inj_seq[«f.injected_channels.length()»] = {
			«FOR row : f.injected_channels»
			«row.ch.getName()»,
			«ENDFOR»
			};
			«ENDIF»
			«IF (f.dual_mode_enabled == true)»
			
			/* Dual mode conversions DMA configuration.*/
			static adc_dma_conf_t «f.name»_dm_dma_conf = {
			«f.dm_dma_stream_id.getName()»,
			«f.dm_dma_stream_bus_priority.getName()»,
			«f.dm_dma_stream_irq_priority.getName()»
			};
			
			/* Dual mode conversions data buffer.*/
			uint32_t «f.dual_buffer»[«f.regular_channels.length()»];
			«ENDIF»
			'''
		}
		return (res)
	}
	
	def String generateSr5e1_saradcCode(Sr5e1_saradc component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "saradc_cfg"

		if (error.severity == Diagnostic.OK) {
			'''
				«generateSr5e1_saradcCopyright()»

				#include <«filename».h>
				#include <dma.h>
				#include <irq.h>
				
				/* Internal configuration data.*/
				«generateSr5e1_saradcdata(component)»

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					void adc_«f.name»(adc_driver_t *adp) {
						
						/* Configure saradc driver instance.*/
						(void)adc_set_data_res(adp, «f.data_resolution.getName()»);
						(void)adc_set_prio(adp, «f.priority.getName()»);
						(void)adc_set_clk_mode(adp, «f.clock_mode.getName()»);
						(void)adc_set_presc(adp, «f.prescaler.getName()»);
						«IF (f.regular_conversion_enabled == true)»
						/* Regular conversions configuration.*/
						«IF (f.enable_dma == true)»
						adc_set_dma_conf(adp, «'&'+f.name+'_reg_dma_conf'»);
						«ENDIF»
						«IF ((f.enable_dma || f.dual_mode_enabled) && !f.dma_error_cb.isNullOrEmpty())»
						(void)adc_set_err_cb(adp, ADC_ERR_DMA, «f.dma_error_cb»);
						«ENDIF»
						(void)adc_set_reg_mode(adp, «f.regular_conversion_mode.getName()»);
						
						«IF (f.enable_dma == true)»
						adc_set_seq(adp, ADC_REG_CONV, «f.regular_channels.length()»U, «f.name+'_reg_seq'», «f.reg_buffer»);
						«ELSE»
						adc_set_seq(adp, ADC_REG_CONV, «f.regular_channels.length()»U, «f.name+'_reg_seq'», NULL);
						«ENDIF»
						«FOR row : f.regular_channels»
						(void)adc_set_smp_time(adp, «row.ch.getName()», «row.sample_time.getName()»);
						(void)adc_set_dif_sel(adp, «row.mode.getValue()»U << «row.ch.getValue()»);
						«ENDFOR»
						«IF (f.regular_trigger_polarity != ext_pol_t.ADC_EXT_POL_DISABLED)»
						adc_set_ext(adp, ADC_REG_CONV, «f.regular_external_trigger»U, «f.regular_trigger_polarity.getName()»);
						«ENDIF»
						«IF (!f.regular_conversions_callback.isNullOrEmpty())»
						(void)adc_set_op_cb(adp, ADC_OP_REG_CONV, «f.regular_conversions_callback»);
						«ENDIF»
						«ENDIF»
						«IF (f.injected_conversion_enabled == true)»
						/* Injected conversions configuration.*/
						adc_set_seq(adp, ADC_INJ_CONV, «f.injected_channels.length()»U, «f.name+'_inj_seq'», «f.inj_buffer»);
						«FOR row : f.injected_channels»
						(void)adc_set_smp_time(adp, «row.ch.getName()», «row.sample_time.getName()»);
						(void)adc_set_dif_sel(adp, «row.mode.getValue()»U);
						«ENDFOR»
						«IF (f.injected_trigger_polarity != ext_pol_t.ADC_EXT_POL_DISABLED)»
						adc_set_ext(adp, ADC_INJ_CONV, «f.injected_external_trigger»U, «f.injected_trigger_polarity.getName()»);
						«ENDIF»
						«IF (!f.injected_conversions_callback.isNullOrEmpty())»
						(void)adc_set_op_cb(adp, ADC_OP_INJ_CONV, «f.injected_conversions_callback»);
						«ENDIF»
						«ENDIF»
						«IF (f.dual_mode_enabled == true)»
						/* Dual mode conversions configuration.*/
						(void)adc_set_dual_mode(adp, «f.dual_mode_mode.getName()»);
						
						adc_set_dual_mode_dma_conf(adp, «'&'+f.name+'_dm_dma_conf'», «f.dual_buffer»);
						(void)adc_set_op_cb(adp, ADC_OP_DUAL_MODE_CONV, «f.dual_mode_callback»);
						«ENDIF»
						«IF (f.aw_1_enabled == true)»
						/* Analog watchdog 1 configuration.*/
						(void)adc_set_aw_ch(adp, ADC_AW_1, «f.channel_aw1.getName()»);
						(void)adc_set_aw_tr(adp, ADC_AW_1, «f.aw_1_lower_threshold»U, «f.aw_1_higher_threshold»U, «f.aw_1_filter»U);
						«IF (!f.aw_1_callback.isNullOrEmpty())»
						(void)adc_set_err_cb(adp, ADC_ERR_AWD1, «f.aw_1_callback»);
						«ENDIF»
						«ENDIF»
						«IF (f.aw_2_enabled == true)»
						/* Analog watchdog 2 configuration.*/
						«FOR ch : f.aw_2_channels»
						(void)adc_set_aw_ch(adp, ADC_AW_2, «ch.getName()»);
						«ENDFOR»
						(void)adc_set_aw_tr(adp, ADC_AW_2, «f.aw_2_lower_threshold»U, «f.aw_2_higher_threshold»U, 1U);
						«IF (!f.aw_2_callback.isNullOrEmpty())»
						(void)adc_set_err_cb(adp, ADC_ERR_AWD2, «f.aw_2_callback»);
						«ENDIF»
						«ENDIF»
						«IF (f.aw_3_enabled == true)»
						/* Analog watchdog 3 configuration.*/
						«FOR ch : f.aw_3_channels»
						(void)adc_set_aw_ch(adp, ADC_AW_3, «ch.getName()»);
						«ENDFOR»
						(void)adc_set_aw_tr(adp, ADC_AW_3, «f.aw_3_lower_threshold»U, «f.aw_3_higher_threshold»U, 1U);
						«IF (!f.aw_3_callback.isNullOrEmpty())»
						(void)adc_set_err_cb(adp, ADC_ERR_AWD3, «f.aw_3_callback»);
						«ENDIF»
						«ENDIF»
						
						/* Enable ADC interrupts.*/
						(void)adc_set_interrupt_en(adp, true);
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
