package com.st.stellar.component.sr5e1_saradc.validation

import com.st.stellar.component.sr5e1_saradc.MSr5e1_saradcPackage
import com.st.stellar.component.sr5e1_saradc.Sr5e1_saradc
import com.st.stellar.component.sr5e1_saradc.util.Sr5e1_saradcValidator
import java.io.File
import java.util.Map
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.common.util.DiagnosticChain
import org.eclipse.emf.ecore.EObject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.resources.IProject
import java.util.regex.Pattern
import com.st.stellar.component.sr5e1_saradc.impl.Sr5e1_saradcImpl
import com.st.stellar.component.sr5e1_saradc.Configuration
import com.st.stellar.component.sr5e1_saradc.impl.MConfigurationImpl
import com.st.stellar.component.sr5e1_saradc.channel_field
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils
import org.eclipse.emf.ecore.EAttribute
import com.st.stellar.component.sr5e1_saradc.Sr5e1_saradcPackage
import org.eclipse.emf.ecore.util.EcoreUtil

class MySr5e1_saradcValidator extends Sr5e1_saradcValidator {

	public static final MySr5e1_saradcValidator INSTANCE = new MySr5e1_saradcValidator();

	Sr5e1_saradc currentComponent = null
	Configuration currentConfiguration = null

	static val ISSUE_CODE_PREFIX = "com.st.stellar.component.sr5e1_saradc."

	static val WRONG_NAME = ISSUE_CODE_PREFIX + 'wrongName'

	static val WRONG_CB = ISSUE_CODE_PREFIX + 'wrongCallback'

	static val REPEATED_CB = ISSUE_CODE_PREFIX + 'repeatedCallback'

	static val WRONG_CHANNEL = ISSUE_CODE_PREFIX + 'wrongChannel'

	static val WRONG_BUFFER = ISSUE_CODE_PREFIX + 'wrongBuffer'

	static val REPEATED_BUFFER = ISSUE_CODE_PREFIX + 'repeatedBuffer'

	override validateConfiguration(Configuration configuration, DiagnosticChain diagnostics,
		Map<Object, Object> context) {
		currentComponent = configuration.eContainer as Sr5e1_saradc
		currentConfiguration = configuration
		super.validateConfiguration(configuration, diagnostics, context)
	}

	override validateSr5e1_saradc(Sr5e1_saradc comp, DiagnosticChain diagnostics, Map<Object, Object> context) {
		currentComponent = comp
		val res = super.validateSr5e1_saradc(comp, diagnostics, context)
		return res
	}

	override validatename_t_checkName(String nameToValidate, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_saradcImpl
		if (parent === null) {
			return true
		}

		var res = checkName(nameToValidate, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_NAME, 0, "_UI_GenericConstraint_diagnostic",
						#["checkName", getValueLabel(MSr5e1_saradcPackage.Literals.NAME_T, nameToValidate, context)],
						#[nameToValidate], context))
				res = false
			}
		}
		return res
	}

	override validatecallback_t_checkCb(String callbackName, DiagnosticChain diagnostics, Map<Object, Object> context) {
		val parent = currentComponent as Sr5e1_saradcImpl
		var res = true

		if (parent === null) {
			return true
		}

		var eClass = currentConfiguration.eClass
		var callbackNameList = eClass.getEAllStructuralFeatures.filter(EAttribute).filter [
			EAttributeType.equals(Sr5e1_saradcPackage.eINSTANCE.getcallback_t)
		].map [ attr |
			{
				val nameValue = currentConfiguration.eGet(attr)
				val value = nameValue !== null ? EcoreUtil.convertToString(attr.getEAttributeType(), nameValue) : ""
				value
			}
		].filterNull

		if (callbackNameList !== null && !callbackNameList.isEmpty) {
			// The new callback name must not be a duplicate
			val thereAreDuplicates = (callbackNameList.filter[it.equals(callbackName) && callbackName.length > 0].size > 1)
			if (thereAreDuplicates) {
				if (diagnostics !== null) {
					diagnostics.add(
						createDiagnostic(Diagnostic.ERROR, REPEATED_CB, 0, "_UI_GenericConstraint_diagnostic",
							#["checkDuplicates",
								getValueLabel(MSr5e1_saradcPackage.Literals.CALLBACK_T, callbackName, context)],
							#[callbackName], context))
				}
				res = false
				return res
			}
		}
		res = checkCb(callbackName, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_CB, 0, "_UI_GenericConstraint_diagnostic",
						#["checkCb", getValueLabel(MSr5e1_saradcPackage.Literals.CALLBACK_T, callbackName, context)],
						#[callbackName], context))
			}
			res = false
		}
		return res
	}

	static val WRONG_PATH = ISSUE_CODE_PREFIX + 'wrongPath'

	override validatePath_checkPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_saradcImpl
		if (parent === null) {
			return true
		}

		var res = checkInputPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_saradcPackage.Literals.PATH, path, context)], #[path],
						context))
				res = false
			}
		}
		return res
	}

	def checkInputPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true

		val project = getProject(comp)
		val fileName = project.getLocation().toOSString + File.separator + location
		val path = new Path(fileName)
		var res = false
		if (path.isValidPath(fileName)) {
			val file = new File(fileName)
			res = file.exists
		}
		res
	}

	public static val WRONG_GENPATH = ISSUE_CODE_PREFIX + 'wrongGenPath'

	override validategenpath_t_checkGenPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_saradcImpl
		if (parent === null) {
			return true
		}

		var res = checkPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_GENPATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_saradcPackage.Literals.GENPATH_T, path, context)], #[path],
						context))
				res = false
			}
		}
		return res
	}

	override validateext_trig_t_checkExtTrig(Long ext_trig_t, DiagnosticChain diagnostics,
		Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_saradcImpl
		if (parent === null) {
			return true
		}

		if (ext_trig_t >= 0 && ext_trig_t <= 31L) {
			return true
		} else {
			return false
		}
	}

	override validatethreshold_t_checkThreshold(Integer threshold_t, DiagnosticChain diagnostics,
		Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_saradcImpl
		val config = currentConfiguration
		if (parent === null) {
			return true
		}

		var max_val = Math::pow(2, config.data_resolution.value) - 1

		if (threshold_t >= 0 && threshold_t <= max_val) {
			return true
		} else {
			return false
		}
	}

	override validatechannel_field_checkCh(channel_field channel_field, DiagnosticChain diagnostics,
		Map<Object, Object> context) {
		var ch_used = null as Iterable<String>

		val parent = currentComponent as Sr5e1_saradcImpl
		val config = currentConfiguration

		if (parent === null) {
			return true
		}

		val reg_ch_used = config.regular_channels.map[cf|cf.ch.literal]

		val inj_ch_used = config.injected_channels.map[cf|cf.ch.literal]

		if (config.regular_conversion_enabled == true && config.injected_conversion_enabled == true) {
			ch_used = reg_ch_used + inj_ch_used
		} else {
			if (config.regular_conversion_enabled == true) {
				ch_used = reg_ch_used
			}
			if (config.injected_conversion_enabled == true) {
				ch_used = inj_ch_used
			}
		}

		if (ch_used === null) {
			return true
		}

		var counter = 0

		for (ch : ch_used) {
			if (ch == channel_field.ch.literal) {
				counter++
			}
		}

		if (counter >= 2) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_CHANNEL, 0, "_UI_GenericConstraint_diagnostic",
						#["checkCh", getValueLabel(MSr5e1_saradcPackage.Literals.CHANNEL_T, channel_field.ch, context)],
						#[channel_field.ch], context))
			}
			return false
		} else {
			return true
		}
	}

	override validatebuffer_t_checkBuffer(String buffer_t, DiagnosticChain diagnostics, Map<Object, Object> context) {
		val parent = currentComponent as Sr5e1_saradcImpl
		var res = true

		if (parent === null) {
			return true
		}

		var eClass = currentConfiguration.eClass
		var bufferList = eClass.getEAllStructuralFeatures.filter(EAttribute).filter [
			EAttributeType.equals(Sr5e1_saradcPackage.eINSTANCE.getbuffer_t)
		].map [ attr |
			{
				val nameValue = currentConfiguration.eGet(attr)
				val value = nameValue !== null ? EcoreUtil.convertToString(attr.getEAttributeType(), nameValue) : ""
				value
			}
		].filterNull

		if (bufferList !== null && !bufferList.isEmpty) {
			// The new buffer name must not be a duplicate
			val thereAreDuplicates = (bufferList.filter[it.equals(buffer_t) && buffer_t.length > 0].size > 1)
			if (thereAreDuplicates) {
				if (diagnostics !== null) {
					diagnostics.add(
						createDiagnostic(Diagnostic.ERROR, REPEATED_BUFFER, 0, "_UI_GenericConstraint_diagnostic",
							#["duplicated buffer name",
								getValueLabel(MSr5e1_saradcPackage.Literals.BUFFER_T, buffer_t, context)],
							#[buffer_t], context))
				}
				res = false
				return res
			}
		}
		res = checkBuff(buffer_t, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_BUFFER, 0, "_UI_GenericConstraint_diagnostic",
						#["wrong syntax", getValueLabel(MSr5e1_saradcPackage.Literals.BUFFER_T, buffer_t, context)],
						#[buffer_t], context))
				res = false
			}
		}
		return res

	}

	static val REGEX_NAME = Pattern.compile('''^[a-zA-Z]+[a-zA-Z0-9_]*$''')

	def checkName(String nameToValidate, DiagnosticChain chain, Map<Object, Object> map) {

		val parent = currentComponent as Sr5e1_saradcImpl
		if (parent === null) {
			return true
		}

		val matches = REGEX_NAME.matcher(nameToValidate).matches
		if (!matches) {
			return false
		}

		// The name is syntactically correct... but may be already present in other configurations
		// Create the list of configuration names already present inside the Sr5e1_saradc main object being validated
		// filter out current configuration (with its old name)
		var name_list = parent.configs.filter(c|c !== currentConfiguration).map[it|(it as MConfigurationImpl).name].
			toList
		if (name_list === null) {
			return true
		}

		// The new name must not be a duplicate
		val noDuplicates = (name_list.filter[it.equals(nameToValidate)].size < 1)
		noDuplicates
	}

	static val REGEX_PATH = Pattern.compile('''^[a-zA-Z0-9-_]+[a-zA-Z0-9-/\\_]*$''')

	def checkPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_PATH.matcher(location)
		var res = matcher.matches()
		res
	}

	static val REGEX_CB = Pattern.compile('''^([a-zA-Z][a-zA-Z0-9_-]*)?$''')

	def checkCb(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_CB.matcher(location)
		var res = matcher.matches()
		res
	}

	static val REGEX_BUFF = Pattern.compile('''^[a-zA-Z][a-zA-Z0-9_-]*$''')

	def checkBuff(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_BUFF.matcher(location)
		var res = matcher.matches()
		res
	}

	static def IProject getProject(EObject model) {
		val uri = model.eResource.URI
		val projectName = uri.segmentsList().get(1).toString()
		return ResourcesPlugin.workspace.root.getProject(projectName)
	}
}
