package com.st.stellar.component.sr5e1_iwdg.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_iwdg.Sr5e1_iwdg
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

class Sr5e1_iwdgCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}

	def String generateSr5e1_iwdgCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}

	def String generateSr5e1_iwdgExportedFunctions(Sr5e1_iwdg component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void iwdg_«f.name»(iwdg_driver_t *idp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_iwdgHeader(Sr5e1_iwdg component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "iwdg_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_iwdgCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <iwdg.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported configuration APIs.*/
				«generateSr5e1_iwdgExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_iwdgCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid IWDG Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}
	
	def String generateSr5e1_iwdgCode(Sr5e1_iwdg component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "iwdg_cfg"

		if (error.severity == Diagnostic.OK) {
			'''
				«generateSr5e1_iwdgCopyright()»

				#include <«filename».h>

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					
					void iwdg_«f.name»(iwdg_driver_t *idp) {
						
						/* Configure iwdg driver instance.*/
						(void)iwdg_set_prescaler(idp, «f.presc.getName()»);
						(void)iwdg_set_counter(idp, «f.counter»);
						(void)iwdg_set_window(idp, «f.window»);
					}
				«ENDFOR»
			'''
		}
	}
	
	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
