package com.st.stellar.component.sr5e1_i2s.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_i2s.Sr5e1_i2s
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

class Sr5e1_i2sCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}

	def String generateSr5e1_i2sCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}
	
	def String generateSr5e1_i2sCbfunc(Sr5e1_i2s component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* These callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			if (!f.tx_cb.isNullOrEmpty() && !cbfunc_list.contains(f.tx_cb)) {
				res = res + '''

					void «f.tx_cb»(i2s_driver_t *idp);
				'''
				cbfunc_list.add(f.tx_cb)
			}
			if (!f.rx_cb.isNullOrEmpty() && !cbfunc_list.contains(f.rx_cb)) {
				res = res + '''

					void «f.rx_cb»(i2s_driver_t *idp);
				'''
				cbfunc_list.add(f.rx_cb)
			}
			if (!f.err_cb.isNullOrEmpty() && !cbfunc_list.contains(f.err_cb)) {
				res = res + '''

					void «f.err_cb»(i2s_driver_t *idp);
				'''
				cbfunc_list.add(f.err_cb)
			}
		}
		return res
	}
	
	def String generateSr5e1_i2sExportedFunctions(Sr5e1_i2s component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void i2s_«f.name»(i2s_driver_t *idp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_i2sHeader(Sr5e1_i2s component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "i2s_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_i2sCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <i2s.h>
				#include <dma.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_i2sCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_i2sExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_i2sCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid I2S Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}
	
	def String generateSr5e1_i2sCode(Sr5e1_i2s component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "i2s_cfg"

		if (error.severity == Diagnostic.OK) {
			'''
				«generateSr5e1_i2sCopyright()»

				#include <«filename».h>
				#include <irq.h>

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					
					void i2s_«f.name»(i2s_driver_t *idp) {
						
						«IF f.dma_en == true»
						static i2s_dma_conf_t i2s_dma_conf = {
						«f.dma_stream_tx_id.getName()»,
						«f.dma_stream_rx_id.getName()»,
						«f.dma_stream_bus_priority.getName()»,
						«f.dma_stream_irq_priority.getName()»
						};
						«ENDIF»
					
						/* Configure i2s driver instance.*/
						(void)i2s_set_prio(idp, «f.prio.getName()»);
						(void)i2s_set_drv_mode(idp, «f.drv_mode.getName()»);
						«IF f.dma_en == true»
						(void)i2s_set_dma_mode(idp, I2S_DMA_ON);
						(void)i2s_set_dma_conf(idp, «'& i2s_dma_conf'»);
						«ENDIF»
						(void)i2s_set_mode(idp, «f.mode.getName()»);
						(void)i2s_set_standard(idp, «f.standard.getName()»);
						(void)i2s_set_chlen(idp, «f.chlen.getName()»);
						(void)i2s_set_datalen(idp, «f.datalen.getName()»);
						(void)i2s_set_ckpol(idp, «f.ckpol.getName()»);
						(void)i2s_set_mckout(idp, «f.mckout.getName()»);
						(void)i2s_set_audiofreq(idp, «f.audiofreq.getName()»);
						«IF !f.tx_cb.isNullOrEmpty()»
						(void)i2s_set_cb(idp, I2S_CB_OPS_TX, «f.tx_cb»);
						«ENDIF»
						«IF !f.rx_cb.isNullOrEmpty()»
						(void)i2s_set_cb(idp, I2S_CB_OPS_RX, «f.rx_cb»);
						«ENDIF»
						«IF !f.err_cb.isNullOrEmpty()»
						(void)i2s_set_cb(idp, I2S_CB_OPS_ERR, «f.err_cb»);
						«ENDIF»
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
