package com.st.stellar.component.sr5e1_i2c.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_i2c.Sr5e1_i2c
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

class Sr5e1_i2cCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}
	
	def String generateSr5e1_i2cCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}
	
	def String generateSr5e1_i2cCbfunc(Sr5e1_i2c component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* These callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			if (!f.done_cb.isNullOrEmpty() && !cbfunc_list.contains(f.done_cb)) {
				res = res + '''

					void «f.done_cb»(i2c_driver_t *idp);
				'''
				cbfunc_list.add(f.done_cb)
			}
			if (!f.err_cb.isNullOrEmpty() && !cbfunc_list.contains(f.err_cb)) {
				res = res + '''

					void «f.err_cb»(i2c_driver_t *idp);
				'''
				cbfunc_list.add(f.err_cb)
			}
		}
		return res
	}
	
	def String generateSr5e1_i2cExportedFunctions(Sr5e1_i2c component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void i2c_«f.name»(i2c_driver_t *idp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_i2cHeader(Sr5e1_i2c component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "i2c_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_i2cCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <i2c.h>
				#include <dma.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_i2cCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_i2cExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_i2cCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid I2C Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}

	def String generateSr5e1_i2cCode(Sr5e1_i2c component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "i2c_cfg"

		if (error.severity == Diagnostic.OK) {
			'''
				«generateSr5e1_i2cCopyright()»

				#include <«filename».h>
				#include <irq.h>

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					
					void i2c_«f.name»(i2c_driver_t *idp) {
						
						«IF f.dma_en == true»
						static i2c_dma_conf_t i2c_dma_conf = {
						«f.dma_stream_tx_id.getName()»,
						«f.dma_stream_rx_id.getName()»,
						«f.dma_stream_bus_priority.getName()»,
						«f.dma_stream_irq_priority.getName()»
						};
						«ENDIF»
					
						/* Configure i2c driver instance.*/
						(void)i2c_set_prio(idp, «f.prio.getName()»);
						(void)i2c_set_drv_mode(idp, «f.drv_mode.getName()»);
						«IF f.dma_en == true»
						(void)i2c_enable_dma(idp, true);
						(void)i2c_set_dma_conf(idp, «'& i2c_dma_conf'»);
						«ENDIF»
						(void)i2c_set_timing(idp, («f.presc» << 28U) | 
												  («f.setup» << 20U) | 
												  («f.hold» << 16U) | 
												  («f.scl_high» << 8U)  | 
												   «f.scl_low»);
						(void)i2c_set_own_address1_mode(idp, «f.oa1_mode.getName()»);
						(void)i2c_set_own_address1(idp, «f.oa1»);
						«IF f.oa2_en == true»
						(void)i2c_enable_own_address2(idp, true);
						(void)i2c_set_own_address2(idp, «f.oa2»);
						(void)i2c_set_address2_mask(idp, «f.oa2_mask.getName()»);
						«ENDIF»
						(void)i2c_enable_general_call(idp, «f.general_call_en»);
						(void)i2c_enable_no_stretch(idp, «f.no_stretch_en»);
						«IF !f.done_cb.isNullOrEmpty()»
						(void)i2c_set_cb(idp, I2C_CB_OPS_DONE, «f.done_cb»);
						«ENDIF»
						«IF !f.err_cb.isNullOrEmpty()»
						(void)i2c_set_cb(idp, I2C_CB_OPS_ERR, «f.err_cb»);
						«ENDIF»
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
