package com.st.stellar.component.sr5e1_hrtim.validation

import com.st.stellar.component.sr5e1_hrtim.MSr5e1_hrtimPackage
import com.st.stellar.component.sr5e1_hrtim.Sr5e1_hrtim
import com.st.stellar.component.sr5e1_hrtim.util.Sr5e1_hrtimValidator
import java.io.File
import java.util.Map
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.common.util.DiagnosticChain
import org.eclipse.emf.ecore.EObject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.resources.IProject
import java.util.regex.Pattern
import com.st.stellar.component.sr5e1_hrtim.impl.Sr5e1_hrtimImpl
import com.st.stellar.component.sr5e1_hrtim.Configuration
import com.st.stellar.component.sr5e1_hrtim.impl.MConfigurationImpl
import org.eclipse.emf.ecore.EAttribute
import com.st.stellar.component.sr5e1_hrtim.Sr5e1_hrtimPackage
import org.eclipse.emf.ecore.util.EcoreUtil

class MySr5e1_hrtimValidator extends Sr5e1_hrtimValidator {

	public static final MySr5e1_hrtimValidator INSTANCE = new MySr5e1_hrtimValidator();

	Sr5e1_hrtim currentComponent = null
	Configuration currentConfiguration = null

	static val ISSUE_CODE_PREFIX = "com.st.stellar.component.sr5e1_hrtim."

	static val WRONG_NAME = ISSUE_CODE_PREFIX + 'wrongName'
	
	static val WRONG_CB = ISSUE_CODE_PREFIX + 'wrongCallback'
	
	static val REPEATED_CB = ISSUE_CODE_PREFIX + 'repeatedCallback'
	
	static val WRONG_HEX = ISSUE_CODE_PREFIX + 'wrongHex'
	
	static val WRONG_TRESH = ISSUE_CODE_PREFIX + 'wrongThreshold'

	override validateConfiguration(Configuration configuration, DiagnosticChain diagnostics,
		Map<Object, Object> context) {
		currentComponent = configuration.eContainer as Sr5e1_hrtim
		currentConfiguration = configuration
		super.validateConfiguration(configuration, diagnostics, context)
	}

	override validateSr5e1_hrtim(Sr5e1_hrtim comp, DiagnosticChain diagnostics, Map<Object, Object> context) {
		currentComponent = comp
		val res = super.validateSr5e1_hrtim(comp, diagnostics, context)
		return res
	}

	override validatename_t_checkName(String nameToValidate, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_hrtimImpl
		if (parent === null) {
			return true
		}

		var res = checkName(nameToValidate, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_NAME, 0, "_UI_GenericConstraint_diagnostic",
						#["checkName", getValueLabel(MSr5e1_hrtimPackage.Literals.NAME_T, nameToValidate, context)],
						#[nameToValidate], context))
				res = false
			}
		}
		return res
	}

	static val WRONG_PATH = ISSUE_CODE_PREFIX + 'wrongPath'

	override validatePath_checkPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_hrtimImpl
		if (parent === null) {
			return true
		}

		var res = checkInputPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_hrtimPackage.Literals.PATH, path, context)], #[path], context))
				res = false
			}
		}
		return res
	}

	def checkInputPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true

		val project = getProject(comp)
		val fileName = project.getLocation().toOSString + File.separator + location
		val path = new Path(fileName)
		var res = false
		if (path.isValidPath(fileName)) {
			val file = new File(fileName)
			res = file.exists
		}
		res
	}

	
	public static val WRONG_GENPATH = ISSUE_CODE_PREFIX + 'wrongGenPath'

	override validategenpath_t_checkGenPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_hrtimImpl
		if (parent === null) {
			return true
		}

		var res = checkPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_GENPATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_hrtimPackage.Literals.GENPATH_T, path, context)], #[path],
						context))
				res = false
			}
		}
		return res
	}
	
	override validatecallback_t_checkCb(String callbackName, DiagnosticChain diagnostics, Map<Object, Object> context) {
		val parent = currentComponent as Sr5e1_hrtimImpl
		var res = true

		if (parent === null) {
			return true
		}

		var eClass = currentConfiguration.eClass
		var callbackNameList = eClass.getEAllStructuralFeatures.filter(EAttribute).filter [
			EAttributeType.equals(Sr5e1_hrtimPackage.eINSTANCE.getcallback_t)
		].map [ attr |
			{
				val nameValue = currentConfiguration.eGet(attr)
				val value = nameValue !== null ? EcoreUtil.convertToString(attr.getEAttributeType(), nameValue) : ""
				value
			}
		].filterNull

		if (callbackNameList !== null && !callbackNameList.isEmpty) {
			// The new callback name must not be a duplicate
			val thereAreDuplicates = (callbackNameList.filter[it.equals(callbackName) && callbackName.length > 0].size > 1)
			if (thereAreDuplicates) {
				if (diagnostics !== null) {
					diagnostics.add(
						createDiagnostic(Diagnostic.ERROR, REPEATED_CB, 0, "_UI_GenericConstraint_diagnostic",
							#["checkDuplicates",
								getValueLabel(MSr5e1_hrtimPackage.Literals.CALLBACK_T, callbackName, context)],
							#[callbackName], context))
				}
				res = false
				return res
			}
		}
		res = checkCb(callbackName, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_CB, 0, "_UI_GenericConstraint_diagnostic",
						#["checkCb", getValueLabel(MSr5e1_hrtimPackage.Literals.CALLBACK_T, callbackName, context)],
						#[callbackName], context))
			}
			res = false
		}
		return res
	}
	
	override validatepostscaler_t_checkHex(String postscaler_t, DiagnosticChain diagnostics, Map<Object, Object> context) {
		
		val parent = currentComponent as Sr5e1_hrtimImpl
		if (parent === null) {
			return true
		}
		
		var res = checkHex(postscaler_t, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_HEX, 0, "_UI_GenericConstraint_diagnostic",
						#["checkHex", getValueLabel(MSr5e1_hrtimPackage.Literals.POSTSCALER_T, postscaler_t, context)], #[postscaler_t],
						context))
				res = false
			}
		}
		return res
	}
	
	override validatethresh_t_checkThresh_t(String thresh_t, DiagnosticChain diagnostics, Map<Object, Object> context) {
			
		val parent = currentComponent as Sr5e1_hrtimImpl
		if (parent === null) {
			return true
		}
		
		var res = checkThresh(thresh_t, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_TRESH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkThresh", getValueLabel(MSr5e1_hrtimPackage.Literals.THRESH_T, thresh_t, context)], #[thresh_t],
						context))
				res = false
			}
		}
		return res
	}

	static val REGEX_NAME = Pattern.compile('''^[a-zA-Z]+[a-zA-Z0-9_]*$''')

	def checkName(String nameToValidate, DiagnosticChain chain, Map<Object, Object> map) {

		val parent = currentComponent as Sr5e1_hrtimImpl
		if (parent === null) {
			return true
		}

		val matches = REGEX_NAME.matcher(nameToValidate).matches
		if (!matches) {
			return false
		}

		// The name is syntactically correct... but may be already present in other configurations
		// Create the list of configuration names already present inside the Sr5e1_hrtim main object being validated
		// filter out current configuration (with its old name)
		var name_list = parent.configs.filter(c|c !== currentConfiguration).map[it|(it as MConfigurationImpl).name].
			toList
		if (name_list === null) {
			return true
		}

		// The new name must not be a duplicate
		val noDuplicates = (name_list.filter[it.equals(nameToValidate)].size < 1)
		noDuplicates
	}

	static val REGEX_PATH = Pattern.compile('''^[a-zA-Z0-9-_]+[a-zA-Z0-9-/\\_]*$''')

	def checkPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_PATH.matcher(location)
		var res = matcher.matches()
		res
	}
	
	static val REGEX_CB = Pattern.compile('''^([a-zA-Z][a-zA-Z0-9_-]*)?$''')

	def checkCb(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_CB.matcher(location)
		var res = matcher.matches()
		res
	}
	
	static val REGEX_HEX = Pattern.compile('''^(0x)[0-1]?[0-9a-fA-F]$''')
	
	def checkHex(String hex, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_HEX.matcher(hex)
		var res = matcher.matches()
		res
	}
	
	static val REGEX_THRESH = Pattern.compile('''^(0x)[0-9a-fA-F]?$''')
	
	def checkThresh(String thresh_t, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		
		val matcher = REGEX_THRESH.matcher(thresh_t)
		var res = matcher.matches()
		res
	}

	static def IProject getProject(EObject model) {
		val uri = model.eResource.URI
		val projectName = uri.segmentsList().get(1).toString()
		return ResourcesPlugin.workspace.root.getProject(projectName)
	}

}
