package com.st.stellar.component.sr5e1_hrtim.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_hrtim.Sr5e1_hrtim
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

import com.st.stellar.component.sr5e1_hrtim.adc_trigger_evt_13_t;
import com.st.stellar.component.sr5e1_hrtim.adc_trigger_evt_24_t;
import com.st.stellar.component.sr5e1_hrtim.preload_t;
import org.eclipse.emf.common.util.EList
import com.st.stellar.component.sr5e1_hrtim.HRTIM_TIMER

class Sr5e1_hrtimCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}

	def String generateSr5e1_hrtimCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''
	}
	
	def String generateSr5e1_hrtimExportedFunctions(Sr5e1_hrtim component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void hrtim_«f.name»(hrtim_driver_t *hdp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_hrtimCbfunc(Sr5e1_hrtim component) {
		var cbfunc_list = newArrayList
		var res = ""
		
		/* These callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			var HRTIM_TIMER[] timers = #[f.HRTIM_TIMER_A, f.HRTIM_TIMER_B, f.HRTIM_TIMER_C, f.HRTIM_TIMER_D, f.HRTIM_TIMER_E, f.HRTIM_TIMER_F]
			
			/* Fault callback.*/
			if (!f.fault_callback.isNullOrEmpty() && !cbfunc_list.contains(f.fault_callback)) {
				res = res + '''

					void «f.fault_callback»(hrtim_driver_t *hdp, uint32_t events);
				'''
				cbfunc_list.add(f.fault_callback)
			}
			
			/* Master callback. */
			if (f.HRTIM_TIMER_MASTER.enable && !f.HRTIM_TIMER_MASTER.master_callback.isNullOrEmpty() && !cbfunc_list.contains(f.HRTIM_TIMER_MASTER.master_callback)) {
				res = res + '''

					void «f.HRTIM_TIMER_MASTER.master_callback»(hrtim_driver_t *hdp, uint32_t events);
				'''
			}
			
			/* Timers callback.*/
			for (t : timers){
				if (t.enable == true) {
					if (t.timer_callback.nullOrEmpty == false && !cbfunc_list.contains(t.timer_callback)){
						res = res + '''

							void «t.timer_callback»(hrtim_driver_t *hdp, uint32_t events);
						'''
						cbfunc_list.add(f.fault_callback)
					}
				}
			}
		}

		return res
	}

	def String generateSr5e1_hrtimHeader(Sr5e1_hrtim component) {

		val error = Diagnostician.INSTANCE.validate(component)

		//val filename = component.name
		val filename = "hrtim_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_hrtimCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <test_env.h>
				#include <hrtim.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_hrtimCbfunc(component)»
				
				/* Exported configuration APIs.*/
				«generateSr5e1_hrtimExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_hrtimCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid HRTIM Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}

	def String generateSr5e1_hrtimCode(Sr5e1_hrtim component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "hrtim_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_hrtimCopyright()»

				#include <«filename».h>

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					«val HRTIM_TIMER[] timers = #[f.HRTIM_TIMER_A, f.HRTIM_TIMER_B, f.HRTIM_TIMER_C, f.HRTIM_TIMER_D, f.HRTIM_TIMER_E, f.HRTIM_TIMER_F]»
					void hrtim_«f.name»(hrtim_driver_t *hdp) {

						/* Configure hrtim driver instance.*/
						(void)hrtim_set_prio(hdp, «f.priority»);
						(void)hrtim_set_fault_prsc(hdp, «f.faults_prescaler.getName»);
						«IF (f.fault_callback.nullOrEmpty == false)»
						(void)hrtim_set_cb(hdp, HRTIM_CB_FAULT, «f.fault_callback»);
						«ENDIF»
						(void)hrtim_set_sync_in(hdp, «f.sync_in.getName»);
						(void)hrtim_set_sync_out(hdp, «f.sync_out.getName»);
						(void)hrtim_set_sync_src(hdp, «f.sync_src.getName»);

						/* ADC trigger event settings.*/
						«IF (f.adc_triggers.tr1en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_1, «adc_trg_evt_13(f.adc_triggers.tr1ev_lst)», «f.adc_triggers.tr1src.getName»);
						«IF (f.adc_triggers.tr1ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_1, «f.adc_triggers.tr1ps»);
						«ENDIF»
						«ENDIF»
						«IF (f.adc_triggers.tr2en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_2, «adc_trg_evt_24(f.adc_triggers.tr2ev_lst)», «f.adc_triggers.tr2src.getName»);
						«IF (f.adc_triggers.tr2ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_2, «f.adc_triggers.tr2ps»);
						«ENDIF»
						«ENDIF»
						«IF (f.adc_triggers.tr3en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_3, «adc_trg_evt_13(f.adc_triggers.tr3ev_lst)», «f.adc_triggers.tr3src.getName»);
						«IF (f.adc_triggers.tr3ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_1, «f.adc_triggers.tr3ps»);
						«ENDIF»
						«ENDIF»
						«IF (f.adc_triggers.tr4en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_4, «adc_trg_evt_24(f.adc_triggers.tr4ev_lst)», «f.adc_triggers.tr4src.getName»);
						«IF (f.adc_triggers.tr4ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_4, «f.adc_triggers.tr4ps»);
						«ENDIF»
						«ENDIF»
						«IF (f.adc_triggers.tr5en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_5, «f.adc_triggers.tr5ev.getName()», «f.adc_triggers.tr5src.getName»);
						«IF (f.adc_triggers.tr5ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_5, «f.adc_triggers.tr5ps»);
						«ENDIF»
						«ENDIF»
						«IF (f.adc_triggers.tr6en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_6, «f.adc_triggers.tr6ev.getName()», «f.adc_triggers.tr6src.getName»);
						«IF (f.adc_triggers.tr6ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_6, «f.adc_triggers.tr6ps»);
						«ENDIF»
						«ENDIF»
						«IF (f.adc_triggers.tr7en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_7, «f.adc_triggers.tr7ev.getName()», «f.adc_triggers.tr7src.getName»);
						«IF (f.adc_triggers.tr7ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_7, «f.adc_triggers.tr7ps»);
						«ENDIF»
						«ENDIF»
						«IF (f.adc_triggers.tr8en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_8, «f.adc_triggers.tr8ev.getName()», «f.adc_triggers.tr8src.getName»);
						«IF (f.adc_triggers.tr8ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_8, «f.adc_triggers.tr8ps»);
						«ENDIF»
						«ENDIF»
						«IF (f.adc_triggers.tr9en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_9, «f.adc_triggers.tr9ev.getName()», «f.adc_triggers.tr9src.getName»);
						«IF (f.adc_triggers.tr9ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_9, «f.adc_triggers.tr9ps»);
						«ENDIF»
						«ENDIF»
						«IF (f.adc_triggers.tr10en == true)»
						hrtim_timer_set_adc_trigger(hdp, HRTIM_ADCTRIGGER_10, «f.adc_triggers.tr10ev.getName()», «f.adc_triggers.tr10src.getName»);
						«IF (f.adc_triggers.tr10ps.nullOrEmpty == false)»
						(void)hrtim_timer_set_adc_post_scaler(hdp, HRTIM_ADCTRIGGER_10, «f.adc_triggers.tr10ps»);
						«ENDIF»
						«ENDIF»

						/* External event settings.*/
						«IF (f.commonEvt1.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_1, «f.commonEvt1.src», «f.commonEvt1.polarity.getName», «f.commonEvt1.sensibility.getName», HRTIM_EVENTFILTER_NONE, «f.commonEvt1.fm.getName»);
						«ENDIF»
						«IF (f.commonEvt2.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_2, «f.commonEvt2.src», «f.commonEvt2.polarity.getName», «f.commonEvt2.sensibility.getName», HRTIM_EVENTFILTER_NONE, «f.commonEvt2.fm.getName»);
						«ENDIF»
						«IF (f.commonEvt3.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_3, «f.commonEvt3.src», «f.commonEvt3.polarity.getName», «f.commonEvt3.sensibility.getName», HRTIM_EVENTFILTER_NONE, «f.commonEvt3.fm.getName»);
						«ENDIF»
						«IF (f.commonEvt4.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_4, «f.commonEvt4.src», «f.commonEvt4.polarity.getName», «f.commonEvt4.sensibility.getName», HRTIM_EVENTFILTER_NONE, «f.commonEvt4.fm.getName»);
						«ENDIF»
						«IF (f.commonEvt5.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_5, «f.commonEvt5.src», «f.commonEvt5.polarity.getName», «f.commonEvt5.sensibility.getName», HRTIM_EVENTFILTER_NONE, «f.commonEvt5.fm.getName»);
						«ENDIF»
						(void)hrtim_set_event_prescaler(hdp, «f.ext_evt_prescaler.getName»);
						«IF (f.commonEvt6.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_6, «f.commonEvt6.src», «f.commonEvt6.polarity.getName», «f.commonEvt6.sensibility.getName», «f.commonEvt6.filter.getName», HRTIM_EVENTFASTMODE_DISABLE);
						«ENDIF»
						«IF (f.commonEvt7.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_7, «f.commonEvt7.src», «f.commonEvt7.polarity.getName», «f.commonEvt7.sensibility.getName», «f.commonEvt7.filter.getName», HRTIM_EVENTFASTMODE_DISABLE);
						«ENDIF»
						«IF (f.commonEvt8.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_8, «f.commonEvt8.src», «f.commonEvt8.polarity.getName», «f.commonEvt8.sensibility.getName», «f.commonEvt8.filter.getName», HRTIM_EVENTFASTMODE_DISABLE);
						«ENDIF»
						«IF (f.commonEvt9.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_9, «f.commonEvt9.src», «f.commonEvt9.polarity.getName», «f.commonEvt9.sensibility.getName», «f.commonEvt9.filter.getName», HRTIM_EVENTFASTMODE_DISABLE);
						«ENDIF»
						«IF (f.commonEvt10.enable == true)»
						hrtim_set_ex_event(hdp, HRTIM_EVENT_10, «f.commonEvt10.src», «f.commonEvt10.polarity.getName», «f.commonEvt10.sensibility.getName», «f.commonEvt10.filter.getName», HRTIM_EVENTFASTMODE_DISABLE);
						«ENDIF»

						/* Timer Master settings.*/
						«IF (f.HRTIM_TIMER_MASTER.enable == true)»
						(void)hrtim_set_timer_mode(hdp, HRTIM_TIMER_MASTER, «f.HRTIM_TIMER_MASTER.mode.getName»);
						(void)hrtim_timer_set_half_intlvd_mode(hdp, HRTIM_TIMER_MASTER, «f.HRTIM_TIMER_MASTER.topology.getName»);
						(void)hrtim_timer_set_prescaler(hdp, HRTIM_TIMER_MASTER, «f.HRTIM_TIMER_MASTER.prescaler.getName»);
						«IF (f.HRTIM_TIMER_MASTER.period === null)»
						(void)hrtim_timer_set_period(hdp, HRTIM_TIMER_MASTER, 0U);
						«ELSE»
						(void)hrtim_timer_set_period(hdp, HRTIM_TIMER_MASTER, «f.HRTIM_TIMER_MASTER.period.intValue»U);
						«ENDIF»
						«IF (f.HRTIM_TIMER_MASTER.comp_1 === null)»
						(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP1, 0U);
						«ELSE»
						(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP1, «f.HRTIM_TIMER_MASTER.comp_1.intValue»U);
						«ENDIF»
						«IF (f.HRTIM_TIMER_MASTER.comp_2 === null)»
						(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP2, 0U);
						«ELSE»
						(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP2, «f.HRTIM_TIMER_MASTER.comp_2.intValue»U);
						«ENDIF»
						«IF (f.HRTIM_TIMER_MASTER.comp_3 === null)»
						(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP3, 0U);
						«ELSE»
						(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP3, «f.HRTIM_TIMER_MASTER.comp_3.intValue»U);
						«ENDIF»
						«IF (f.HRTIM_TIMER_MASTER.comp_4 === null)»
						(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP4, 0U);
						«ELSE»
						(void)hrtim_timer_set_cmp(hdp, HRTIM_TIMER_MASTER, HRTIM_CMP4, «f.HRTIM_TIMER_MASTER.comp_4.intValue»U);
						«ENDIF»
						hrtim_timer_set_preload_update(hdp, HRTIM_TIMER_MASTER, «f.HRTIM_TIMER_MASTER.preload_en.getName», «f.HRTIM_TIMER_MASTER.update_event.getName»);
						«IF (f.HRTIM_TIMER_MASTER.master_callback.nullOrEmpty == false)»
						(void)hrtim_set_cb(hdp, HRTIM_CB_MASTER, «f.HRTIM_TIMER_MASTER.master_callback»);
						«ENDIF»
						(void)hrtim_enable_sync_start(hdp, HRTIM_TIMER_MASTER, «f.HRTIM_TIMER_MASTER.sync_start_en»);
						(void)hrtim_enable_sync_reset(hdp, HRTIM_TIMER_MASTER, «f.HRTIM_TIMER_MASTER.sync_reset_en»);
						«ENDIF»

						«FOR t : timers»
						«val timer_name = get_timer_name(t)»
						«IF (t.enable == true)»
						/* «timer_name» settings.*/
						(void)hrtim_set_timer_mode(hdp, «timer_name», «t.mode.getName»);
						(void)hrtim_timer_set_up_down_mode(hdp, «timer_name», «t.count_mode.getName»);
						(void)hrtim_timer_set_prescaler(hdp, «timer_name», «t.prescaler.getName»);
						«IF (t.period === null)»
						(void)hrtim_timer_set_period(hdp, «timer_name», 0U);
						«ELSE»
						(void)hrtim_timer_set_period(hdp, «timer_name», «t.period.intValue»U);
						«ENDIF»
						«IF (t.counter_reset_event.nullOrEmpty == false)»
						(void)hrtim_timer_set_counter_reset_event(hdp, «timer_name», «t.counter_reset_event»);
						«ELSE»
						(void)hrtim_timer_set_counter_reset_event(hdp, «timer_name», HRTIM_COUNTER_RESET_NOEVENT);
						«ENDIF»
						(void)hrtim_timer_set_half_intlvd_mode(hdp, «timer_name», «t.topology.getName»);
						(void)hrtim_timer_set_preload_update(hdp, «timer_name», «t.preload_en.getName», «t.update_event.getName»);
						«IF (t.dual_dac_trigger_en == true)»
						(void)hrtim_timer_enable_dualdac_trigger(hdp, «timer_name»);
						«ENDIF»
						«IF (t.timer_callback.nullOrEmpty == false)»
						(void)hrtim_set_cb(hdp, «get_timer_callback(t)», «t.timer_callback»);
						«ENDIF»
						«IF (t.comp_1 === null)»
						(void)hrtim_timer_set_cmp(hdp, «timer_name», HRTIM_CMP1, 0U);
						«ELSE»
						(void)hrtim_timer_set_cmp(hdp, «timer_name», HRTIM_CMP1, «t.comp_1.intValue»U);
						«ENDIF»
						«IF (t.comp_2 === null)»
						(void)hrtim_timer_set_cmp(hdp, «timer_name», HRTIM_CMP2, 0U);
						«ELSE»
						(void)hrtim_timer_set_cmp(hdp, «timer_name», HRTIM_CMP2, «t.comp_2.intValue»U);
						«ENDIF»
						(void)hrtim_timer_set_autodelay(hdp, «timer_name», HRTIM_CMP2, «t.ad_mode_cmp_2.getName»);
						«IF (t.comp_3 === null)»
						(void)hrtim_timer_set_cmp(hdp, «timer_name», HRTIM_CMP3, 0U);
						«ELSE»
						(void)hrtim_timer_set_cmp(hdp, «timer_name», HRTIM_CMP3, «t.comp_3.intValue»U);
						«ENDIF»
						«IF (t.comp_4 === null)»
						(void)hrtim_timer_set_cmp(hdp, «timer_name», HRTIM_CMP4, 0U);
						«ELSE»
						(void)hrtim_timer_set_cmp(hdp, «timer_name», HRTIM_CMP4, «t.comp_4.intValue»U);
						«ENDIF»
						(void)hrtim_timer_set_autodelay(hdp, «timer_name», HRTIM_CMP4, «t.ad_mode_cmp_4.getName»);
						«IF (t.enable_deadtime == true)»
						«IF ((t.deadtime.rvalue === null) && (t.deadtime.fvalue === null))»
						hrtim_timer_set_deadtime(hdp, «timer_name», «t.deadtime.prescaler.getName», 0U, «t.deadtime.rsign.getName», 0U, «t.deadtime.fsign.getName»);
						«ELSEIF (t.deadtime.rvalue === null)»
						hrtim_timer_set_deadtime(hdp, «timer_name», «t.deadtime.prescaler.getName», 0U, «t.deadtime.rsign.getName», «t.deadtime.fvalue.intValue»U, «t.deadtime.fsign.getName»);
						«ELSEIF (t.deadtime.fvalue === null)»
						hrtim_timer_set_deadtime(hdp, «timer_name», «t.deadtime.prescaler.getName», «t.deadtime.rvalue.intValue»U, «t.deadtime.rsign.getName», 0U, «t.deadtime.fsign.getName»);
						«ELSE»
						hrtim_timer_set_deadtime(hdp, «timer_name», «t.deadtime.prescaler.getName», «t.deadtime.rvalue.intValue»U, «t.deadtime.rsign.getName», «t.deadtime.fvalue.intValue»U, «t.deadtime.fsign.getName»);
						«ENDIF»
						hrtim_timer_enable_deadtime(hdp, «timer_name»);
						«ENDIF»
						«IF (t.sync_start_en == true)»
						(void)hrtim_enable_sync_start(hdp, «timer_name», true);
						«ELSE»
						(void)hrtim_enable_sync_start(hdp, «timer_name», false);
						«ENDIF»
						«IF (t.sync_reset_en == true)»
						(void)hrtim_enable_sync_reset(hdp, «timer_name», true);
						«ELSE»
						(void)hrtim_enable_sync_reset(hdp, «timer_name», false);
						«ENDIF»
						«IF (t.output_1_set.nullOrEmpty == true)»
						(void)hrtim_timer_set_outputset(hdp, «timer_name», HRTIM_TIMER_OUTPUT_1, HRTIM_OUTPUT_NONE);
						«ELSE»
						(void)hrtim_timer_set_outputset(hdp, «timer_name», HRTIM_TIMER_OUTPUT_1, «t.output_1_set»);
						«ENDIF»
						«IF (t.output_1_reset.nullOrEmpty == true)»
						(void)hrtim_timer_set_outputrst(hdp, «timer_name», HRTIM_TIMER_OUTPUT_1, HRTIM_OUTPUT_NONE);
						«ELSE»
						(void)hrtim_timer_set_outputrst(hdp, «timer_name», HRTIM_TIMER_OUTPUT_1, «t.output_1_reset»);
						«ENDIF»
						(void)hrtim_timer_set_output_faultstate(hdp, «timer_name», HRTIM_TIMER_OUTPUT_1, «t.out_common.out_1_faultstate.getName»);
						(void)hrtim_timer_set_output_idlestate(hdp, «timer_name», HRTIM_TIMER_OUTPUT_1, «t.out_common.out_1_idlestate.getName»);
						(void)hrtim_timer_set_output_polarity(hdp, «timer_name», HRTIM_TIMER_OUTPUT_1, «t.out_common.out_1_polarity.getName»);
						«IF (t.output_2_set.nullOrEmpty == true)»
						(void)hrtim_timer_set_outputset(hdp, «timer_name», HRTIM_TIMER_OUTPUT_2, HRTIM_OUTPUT_NONE);
						«ELSE»
						(void)hrtim_timer_set_outputset(hdp, «timer_name», HRTIM_TIMER_OUTPUT_2, «t.output_2_set»);
						«ENDIF»
						«IF (t.output_2_reset.nullOrEmpty == true)»
						(void)hrtim_timer_set_outputrst(hdp, «timer_name», HRTIM_TIMER_OUTPUT_2, HRTIM_OUTPUT_NONE);
						«ELSE»
						(void)hrtim_timer_set_outputrst(hdp, «timer_name», HRTIM_TIMER_OUTPUT_2, «t.output_2_reset»);
						«ENDIF»
						(void)hrtim_timer_set_output_faultstate(hdp, «timer_name», HRTIM_TIMER_OUTPUT_2, «t.out_common.out_2_faultstate.getName»);
						(void)hrtim_timer_set_output_idlestate(hdp, «timer_name», HRTIM_TIMER_OUTPUT_2, «t.out_common.out_2_idlestate.getName»);
						(void)hrtim_timer_set_output_polarity(hdp, «timer_name», HRTIM_TIMER_OUTPUT_2, «t.out_common.out_2_polarity.getName»);
						«IF (f.commonEvt1.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_1, «t.ext_ev_1.filter.getName», «t.ext_ev_1.latch.getName»);
						«ENDIF»
						«IF (f.commonEvt2.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_2, «t.ext_ev_2.filter.getName», «t.ext_ev_2.latch.getName»);
						«ENDIF»
						«IF (f.commonEvt3.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_3, «t.ext_ev_3.filter.getName», «t.ext_ev_3.latch.getName»);
						«ENDIF»
						«IF (f.commonEvt4.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_4, «t.ext_ev_4.filter.getName», «t.ext_ev_4.latch.getName»);
						«ENDIF»
						«IF (f.commonEvt5.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_5, «t.ext_ev_5.filter.getName», «t.ext_ev_5.latch.getName»);
						«ENDIF»
						«IF (f.commonEvt6.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_6, «t.ext_ev_6.blnk_filter.getName», «t.ext_ev_6.latch.getName»);
						«ENDIF»
						«IF (f.commonEvt7.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_7, «t.ext_ev_7.blnk_filter.getName», «t.ext_ev_7.latch.getName»);
						«ENDIF»
						«IF (f.commonEvt8.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_8, «t.ext_ev_8.blnk_filter.getName», «t.ext_ev_8.latch.getName»);
						«ENDIF»
						«IF (f.commonEvt9.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_9, «t.ext_ev_9.blnk_filter.getName», «t.ext_ev_9.latch.getName»);
						«ENDIF»
						«IF (f.commonEvt10.enable == true)»
						(void)hrtim_timer_set_eev_filtering(hdp, «timer_name», HRTIM_EVENT_10, «t.ext_ev_10.blnk_filter.getName», «t.ext_ev_10.latch.getName»);
						«ENDIF»
						«IF (t.cnt_thresh === null)»
						(void)hrtim_ext_even_counter_cfg(hdp, «timer_name», «t.cnt_ext_ev_id.getName», «t.cnt_rst_mode.getName», «t.cnt_src.getName», 0U);
						«ELSE»
						(void)hrtim_ext_even_counter_cfg(hdp, «timer_name», «t.cnt_ext_ev_id.getName», «t.cnt_rst_mode.getName», «t.cnt_src.getName», «t.cnt_thresh»);
						«ENDIF»
						«IF (t.count_mode.literal.contains("Up-down counting mode") == true)»
						(void)hrtim_timer_set_adc_rollover(hdp, «timer_name», «t.adc_rollover_mode.getName»);
						(void)hrtim_timer_set_fault_event_rollover(hdp, «timer_name», «t.fault_event_rollover_mode.getName»);
						(void)hrtim_timer_set_out_rollover(hdp, «timer_name», «t.output_rollover_mode.getName»);
						(void)hrtim_timer_set_burstmode_rollover(hdp, «timer_name», «t.burstmode_rollover_mode.getName»);
						(void)hrtim_timer_set_rollover(hdp, «timer_name», «t.hrtim_rollover_mode.getName»);
						«ENDIF»
						
						«IF (t.cpt_1_src.isNullOrEmpty && !t.cpt_2_src.isNullOrEmpty)»
						hrtim_timer_set_capture_unit(hdp, «timer_name», HRTIM_CAPTURE_TRG_NONE, «capture_trg(t.cpt_2_src)»);
                        «ENDIF»
                        «IF (!t.cpt_1_src.isNullOrEmpty && t.cpt_2_src.isNullOrEmpty)»
					    hrtim_timer_set_capture_unit(hdp, «timer_name», «capture_trg(t.cpt_1_src)», HRTIM_CAPTURE_TRG_NONE);
                        «ENDIF»
                        «IF (!t.cpt_1_src.isNullOrEmpty && !t.cpt_2_src.isNullOrEmpty)»
						hrtim_timer_set_capture_unit(hdp, «timer_name», «capture_trg(t.cpt_1_src)», «capture_trg(t.cpt_2_src)»);
                        «ENDIF»
						«ENDIF»
						«ENDFOR»

						/* Common fault settings.*/
						«IF (f.commonFault_1.enable == true)»
						«IF (f.commonFault_1.source.nullOrEmpty == false)»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_1, true, «f.commonFault_1.source», «f.commonFault_1.polarity.getName», «f.commonFault_1.filter.getName», «f.commonFault_1.lock.getName»);
						«ELSE»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_1, true, HRTIM1_FAULTSOURCE_FLT1_GPIO, «f.commonFault_1.polarity.getName», «f.commonFault_1.filter.getName», «f.commonFault_1.lock.getName»);
						«ENDIF»
						hrtim_set_fault_counter_cfg(hdp, HRTIM_FAULT_1, «f.commonFault_1.counter_thresh», «f.commonFault_1.counter_rst_mode.getName», «f.commonFault_1.counter_blk_en.booleanValue», «f.commonFault_1.counter_blk_src.getName»);
						«ENDIF»
						«IF (f.commonFault_2.enable == true)»
						«IF (f.commonFault_2.source.nullOrEmpty == false)»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_2, true, «f.commonFault_2.source», «f.commonFault_2.polarity.getName», «f.commonFault_2.filter.getName», «f.commonFault_2.lock.getName»);
						«ELSE»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_2, true, HRTIM1_FAULTSOURCE_FLT2_GPIO, «f.commonFault_2.polarity.getName», «f.commonFault_2.filter.getName», «f.commonFault_2.lock.getName»);
						«ENDIF»
						hrtim_set_fault_counter_cfg(hdp, HRTIM_FAULT_2, «f.commonFault_2.counter_thresh», «f.commonFault_2.counter_rst_mode.getName», «f.commonFault_2.counter_blk_en.booleanValue», «f.commonFault_2.counter_blk_src.getName»);
						«ENDIF»
						«IF (f.commonFault_3.enable == true)»
						«IF (f.commonFault_3.source.nullOrEmpty == false)»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_3, true, «f.commonFault_3.source», «f.commonFault_3.polarity.getName», «f.commonFault_3.filter.getName», «f.commonFault_3.lock.getName»);
						«ELSE»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_3, true, HRTIM1_FAULTSOURCE_FLT3_GPIO, «f.commonFault_3.polarity.getName», «f.commonFault_3.filter.getName», «f.commonFault_3.lock.getName»);
						«ENDIF»
						hrtim_set_fault_counter_cfg(hdp, HRTIM_FAULT_3, «f.commonFault_3.counter_thresh», «f.commonFault_3.counter_rst_mode.getName», «f.commonFault_3.counter_blk_en.booleanValue», «f.commonFault_3.counter_blk_src.getName»);
						«ENDIF»
						«IF (f.commonFault_4.enable == true)»
						«IF (f.commonFault_4.source.nullOrEmpty == false)»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_4, true, «f.commonFault_4.source», «f.commonFault_4.polarity.getName», «f.commonFault_4.filter.getName», «f.commonFault_4.lock.getName»);
						«ELSE»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_4, true, HRTIM1_FAULTSOURCE_FLT4_GPIO, «f.commonFault_4.polarity.getName», «f.commonFault_4.filter.getName», «f.commonFault_4.lock.getName»);
						«ENDIF»
						hrtim_set_fault_counter_cfg(hdp, HRTIM_FAULT_4, «f.commonFault_4.counter_thresh», «f.commonFault_4.counter_rst_mode.getName», «f.commonFault_4.counter_blk_en.booleanValue», «f.commonFault_4.counter_blk_src.getName»);
						«ENDIF»
						«IF (f.commonFault_5.enable == true)»
						«IF (f.commonFault_5.source.nullOrEmpty == false)»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_5, true, «f.commonFault_5.source», «f.commonFault_5.polarity.getName», «f.commonFault_5.filter.getName», «f.commonFault_5.lock.getName»);
						«ELSE»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_5, true, HRTIM1_FAULTSOURCE_FLT5_GPIO, «f.commonFault_5.polarity.getName», «f.commonFault_5.filter.getName», «f.commonFault_5.lock.getName»);
						«ENDIF»
						hrtim_set_fault_counter_cfg(hdp, HRTIM_FAULT_5, «f.commonFault_5.counter_thresh», «f.commonFault_5.counter_rst_mode.getName», «f.commonFault_5.counter_blk_en.booleanValue», «f.commonFault_5.counter_blk_src.getName»);
						«ENDIF»
						«IF (f.commonFault_6.enable == true)»
						«IF (f.commonFault_6.source.nullOrEmpty == false)»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_6, true, «f.commonFault_6.source», «f.commonFault_6.polarity.getName», «f.commonFault_6.filter.getName», «f.commonFault_6.lock.getName»);
						«ELSE»
						hrtim_set_fault_cfg(hdp, HRTIM_FAULT_6, true, HRTIM1_FAULTSOURCE_FLT6_GPIO, «f.commonFault_6.polarity.getName», «f.commonFault_6.filter.getName», «f.commonFault_6.lock.getName»);
						«ENDIF»
						hrtim_set_fault_counter_cfg(hdp, HRTIM_FAULT_6, «f.commonFault_6.counter_thresh», «f.commonFault_6.counter_rst_mode.getName», «f.commonFault_6.counter_blk_en.booleanValue», «f.commonFault_6.counter_blk_src.getName»);
						«ENDIF»

					}
				«ENDFOR»

			'''
		}
	}

	def String get_timer_name(HRTIM_TIMER timer) {
		var String timer_name;


		if (timer.eClass.name.contentEquals("HRTIM_TIMERA") == true) {
			timer_name = "HRTIM_TIMER_A";
		} else if (timer.eClass.name.contentEquals("HRTIM_TIMERB") == true) {
			timer_name = "HRTIM_TIMER_B";
		} else if (timer.eClass.name.contentEquals("HRTIM_TIMERC") == true) {
			timer_name = "HRTIM_TIMER_C";
		} else if (timer.eClass.name.contentEquals("HRTIM_TIMERD") == true) {
			timer_name = "HRTIM_TIMER_D";
		} else if (timer.eClass.name.contentEquals("HRTIM_TIMERE") == true) {
			timer_name = "HRTIM_TIMER_E";
		} else {
			timer_name = "HRTIM_TIMER_F";		
		}

		return timer_name;
	}

	def String get_timer_callback(HRTIM_TIMER timer) {
		var String timer_callback;


		if (timer.eClass.name.contentEquals("HRTIM_TIMERA") == true) {
			timer_callback = "HRTIM_CB_TIMER_A";
		} else if (timer.eClass.name.contentEquals("HRTIM_TIMERB") == true) {
			timer_callback = "HRTIM_CB_TIMER_B";
		} else if (timer.eClass.name.contentEquals("HRTIM_TIMERC") == true) {
			timer_callback = "HRTIM_CB_TIMER_C";
		} else if (timer.eClass.name.contentEquals("HRTIM_TIMERD") == true) {
			timer_callback = "HRTIM_CB_TIMER_D";
		} else if (timer.eClass.name.contentEquals("HRTIM_TIMERE") == true) {
			timer_callback = "HRTIM_CB_TIMER_E";
		} else {
			timer_callback = "HRTIM_CB_TIMER_F";		
		}

		return timer_callback;
	}

	def String adc_trg_evt_13(EList<adc_trigger_evt_13_t> trev_lst) {
		var String event_trigger = "";

		if (trev_lst.nullOrEmpty == false) {
			for ( x : trev_lst ) {
				if (x.toString.contains("HRTIM_ADCTRIGGEREVENT13_NONE") == false) {
					if (event_trigger.nullOrEmpty == true) {
						event_trigger = x.getName();
					} else {
						event_trigger = event_trigger + " | " + x.getName();
					}
				}
			}
		} else {
			event_trigger = "HRTIM_ADCTRIGGEREVENT13_NONE";
		}

		return event_trigger;
	}

	def String adc_trg_evt_24(EList<adc_trigger_evt_24_t> trev_lst) {
		var String event_trigger = ""

		if (trev_lst.nullOrEmpty == false) {
			for ( x : trev_lst ) {
				if (x.toString.contains("HRTIM_ADCTRIGGEREVENT24_NONE") == false) {
					if (event_trigger.nullOrEmpty == true) {
						event_trigger = x.getName();
					} else {
						event_trigger = event_trigger + " | " + x.getName();
					}
				}
			}	
		} else {
			event_trigger = "HRTIM_ADCTRIGGEREVENT24_NONE";
		}

		return event_trigger
	}

	def String capture_trg(EList<String> trg_lst) {
		var String capture_trigger = "";

		if (trg_lst.nullOrEmpty == false) {
			for ( x : trg_lst ) {
				if (x.contains("HRTIM_CAPTURE_TRG_NONE") == false) {
					if (capture_trigger.nullOrEmpty == true) {
						capture_trigger = x;
					} else {
						capture_trigger = capture_trigger + " | " + x;
					}
				}
			}
		} else {
			capture_trigger = "HRTIM_CAPTURE_TRG_NONE";
		}

		return capture_trigger;
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}

interface Elist {
}
