package com.st.stellar.component.sr5e1_dac.validation

import com.st.stellar.component.sr5e1_dac.MSr5e1_dacPackage
import com.st.stellar.component.sr5e1_dac.Sr5e1_dac
import com.st.stellar.component.sr5e1_dac.util.Sr5e1_dacValidator
import java.io.File
import java.util.Map
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.common.util.DiagnosticChain
import org.eclipse.emf.ecore.EObject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.resources.IProject
import java.util.regex.Pattern
import com.st.stellar.component.sr5e1_dac.impl.Sr5e1_dacImpl
import com.st.stellar.component.sr5e1_dac.Configuration
import com.st.stellar.component.sr5e1_dac.impl.MConfigurationImpl

class MySr5e1_dacValidator extends Sr5e1_dacValidator {

	public static final MySr5e1_dacValidator INSTANCE = new MySr5e1_dacValidator();

	Sr5e1_dac currentComponent = null
	Configuration currentConfiguration = null

	static val ISSUE_CODE_PREFIX = "com.st.stellar.component.sr5e1_dac."

	static val WRONG_NAME = ISSUE_CODE_PREFIX + 'wrongName'

	override validateConfiguration(Configuration configuration, DiagnosticChain diagnostics,
		Map<Object, Object> context) {
		currentComponent = configuration.eContainer as Sr5e1_dac
		currentConfiguration = configuration
		super.validateConfiguration(configuration, diagnostics, context)
	}

	override validateSr5e1_dac(Sr5e1_dac comp, DiagnosticChain diagnostics, Map<Object, Object> context) {
		currentComponent = comp
		val res = super.validateSr5e1_dac(comp, diagnostics, context)
		return res
	}

	override validatename_t_checkName(String nameToValidate, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_dacImpl
		if (parent === null) {
			return true
		}

		var res = checkName(nameToValidate, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_NAME, 0, "_UI_GenericConstraint_diagnostic",
						#["checkName", getValueLabel(MSr5e1_dacPackage.Literals.NAME_T, nameToValidate, context)],
						#[nameToValidate], context))
				res = false
			}
		}
		return res
	}

	static val WRONG_PATH = ISSUE_CODE_PREFIX + 'wrongPath'

	override validatePath_checkPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_dacImpl
		if (parent === null) {
			return true
		}

		var res = checkInputPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_dacPackage.Literals.PATH, path, context)], #[path], context))
				res = false
			}
		}
		return res
	}

	def checkInputPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true

		val project = getProject(comp)
		val fileName = project.getLocation().toOSString + File.separator + location
		val path = new Path(fileName)
		var res = false
		if (path.isValidPath(fileName)) {
			val file = new File(fileName)
			res = file.exists
		}
		res
	}

	
	public static val WRONG_GENPATH = ISSUE_CODE_PREFIX + 'wrongGenPath'

	override validategenpath_t_checkGenPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_dacImpl
		if (parent === null) {
			return true
		}

		var res = checkPath(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_GENPATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_dacPackage.Literals.GENPATH_T, path, context)], #[path],
						context))
				res = false
			}
		}
		return res
	}

	static val REGEX_NAME = Pattern.compile('''^[a-zA-Z]+[a-zA-Z0-9_]*$''')

	def checkName(String nameToValidate, DiagnosticChain chain, Map<Object, Object> map) {

		val parent = currentComponent as Sr5e1_dacImpl
		if (parent === null) {
			return true
		}

		val matches = REGEX_NAME.matcher(nameToValidate).matches
		if (!matches) {
			return false
		}

		// The name is syntactically correct... but may be already present in other configurations
		// Create the list of configuration names already present inside the Sr5e1 main object being validated
		// filter out current configuration (with its old name)
		var name_list = parent.configs.filter(c|c !== currentConfiguration).map[it|(it as MConfigurationImpl).name].
			toList
		if (name_list === null) {
			return true
		}

		// The new name must not be a duplicate
		val noDuplicates = (name_list.filter[it.equals(nameToValidate)].size < 1)
		noDuplicates
	}
	
	override validatecallback_t_checkCb(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {

		val parent = currentComponent as Sr5e1_dacImpl
		if (parent === null) {
			return true
		}

		var res = checkCb(path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MSr5e1_dacPackage.Literals.CALLBACK_T, path, context)], #[path],
						context))
				res = false
			}
		}
		return res
	}

	static val REGEX_PATH = Pattern.compile('''^[a-zA-Z0-9-_]+[a-zA-Z0-9-/\\_]*$''')

	def checkPath(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_PATH.matcher(location)
		var res = matcher.matches()
		res
	}
	
	static val REGEX_CB = Pattern.compile('''^([a-zA-Z][a-zA-Z0-9_-]*)?$''')

	def checkCb(String location, DiagnosticChain chain, Map<Object, Object> map) {
		val comp = currentComponent
		if(comp === null) return true
		val matcher = REGEX_CB.matcher(location)
		var res = matcher.matches()
		res
	}

	static def IProject getProject(EObject model) {
		val uri = model.eResource.URI
		val projectName = uri.segmentsList().get(1).toString()
		return ResourcesPlugin.workspace.root.getProject(projectName)
	}

	
}
