package com.st.stellar.component.sr5e1_dac.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_dac.Sr5e1_dac
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

import com.st.stellar.component.sr5e1_dac.dma_mode_t
import com.st.stellar.component.sr5e1_dac.trigger_src_t

class Sr5e1_dacCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}
	
	def String generateSr5e1_dacCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}
	
	def String generateSr5e1_dacCbfunc(Sr5e1_dac component) {
		var cbfunc_list = newArrayList
		var res = ""

		/* This callbacks are automatically declared here but they MUST be implemented
		   in your code.*/
		for (f : component.configs.filter[enabled]) {
			if (!f.parity_error_callback.isNullOrEmpty() && !cbfunc_list.contains(f.parity_error_callback)) {
				res = res + '''

					void «f.parity_error_callback»(dac_driver_t *ddp);
				'''
				cbfunc_list.add(f.parity_error_callback)
			}
			if (!f.parity_error_callback.isNullOrEmpty() && !cbfunc_list.contains(f.parity_error_callback)) {
				res = res + '''

					void «f.parity_error_callback»(dac_driver_t *ddp);
				'''
				cbfunc_list.add(f.parity_error_callback)
			}
		}

		return res
	}
	
	def String generateSr5e1_dacExportedFunctions(Sr5e1_dac component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void dac_«f.name»(dac_driver_t *ddp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_dacHeader(Sr5e1_dac component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "dac_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_dacCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <dac.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_dacCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_dacExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_dacCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid DAC Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}
	
	def String generateSr5e1_dacdata(Sr5e1_dac component) {
		var res = ""

		for (f : component.configs.filter[enabled]) {
			if (f.DMA_mode != dma_mode_t.DAC_DMA_OFF) {
				res = res + '''

				static dac_dma_conf_t «f.name»_dma_conf = {
					«f.dma_stream_id.getName()»,
					«f.dma_stream_bus_priority.getName()»,
					«f.dma_stream_irq_priority.getName()»
				};'''
			}
		}
		return (res)

	}
	
	def String generateSr5e1_dacCode(Sr5e1_dac component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "dac_cfg"
		var is_dma_enable = false

		if (error.severity == Diagnostic.OK) {
			for ( f : component.configs.filter[enabled]) {
				if (f.DMA_mode != dma_mode_t.DAC_DMA_OFF) {
			    		is_dma_enable = true;
			    }
			}
			'''
				«generateSr5e1_dacCopyright()»

				#include <«filename».h>
				«IF (is_dma_enable == true)»
				#include <dma.h>
				«ENDIF»
				#include <irq.h>
				
				/* Internal configuration data.*/
				«generateSr5e1_dacdata(component)»

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					
					void dac_«f.name»(dac_driver_t *ddp) {
					
						/* Configure dac driver instance.*/
						(void)dac_set_mode(ddp, «f.mode.getName()»);
						(void)dac_set_highfreq_mode(ddp, «f.high_frequency_mode.getName()»);
						(void)dac_set_format(ddp, «f.channel.getName()», «f.data_format.getName()»);
						(void)dac_set_output_connection(ddp, «f.channel.getName()», «f.output_connection.getName()»);
						(void)dac_set_wave(ddp, «f.channel.getName()», «f.wave_mode.getName()»);
						(void)dac_set_dma_mode(ddp, «f.channel.getName()», «f.DMA_mode.getName()»);
						«IF (f.DMA_mode != dma_mode_t.DAC_DMA_OFF)»
						dac_set_dma_conf(ddp, «f.channel.getName()», «'&'+f.name+'_dma_conf'»);
						«ENDIF»
						(void)dac_set_trigger_src(ddp, «f.channel.getName()», «f.trigger_source.getName()»);
						«IF ((f.trigger_source != trigger_src_t.DAC_SWTRIG) && (f.trigger_enable == true))»
						(void)dac_enable_trigger(ddp, «f.channel.getName()», true);
						«ENDIF»
						(void)dac_set_inc_trigger_src(ddp, «f.channel.getName()», «f.increment_source.getName()»);
						(void)dac_set_rst_trigger_src(ddp, «f.channel.getName()», «f.reset_source.getName()»);
						«IF (!f.parity_error_callback.isNullOrEmpty())»
						(void)dac_set_cb(ddp, «f.parity_error_callback»);
						«ENDIF»
						«IF (f.channel_enable == true)»
						(void)dac_enable_channel(ddp, «f.channel.getName()», true);
						«ENDIF»
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
