package com.st.stellar.component.sr5e1_cordic.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.sr5e1_cordic.Sr5e1_cordic
import org.eclipse.emf.ecore.util.Diagnostician
import org.eclipse.emf.common.util.Diagnostic

import com.st.stellar.component.sr5e1_cordic.drv_mode_t

class Sr5e1_cordicCodeGenerator extends AbstractGenerator {

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
	}
	
	def String generateSr5e1_cordicCopyright() {
		'''
			/****************************************************************************
			 *
			 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
			 *
			 * License terms: STMicroelectronics Proprietary in accordance with licensing
			 * terms SLA0098 at www.st.com.
			 *
			 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			 *
			 * DO NOT EDIT: Automatically generated file
			 *****************************************************************************/
		'''

	}

	def String generateSr5e1_cordicCbfunc(Sr5e1_cordic component) {
		var cbfunc_list = newArrayList
		var res = ""

		for (f : component.configs.filter[enabled]) {
			if (f.drv_mode != drv_mode_t.CORDIC_DRV_MODE_POLLING_SYNC) {
				if (!f.callback.isNullOrEmpty() && !cbfunc_list.contains(f.callback)) {
					/* This callback is automatically declared here but it MUST be implemented
					   in your code.*/
					res = res + '''
						void «f.callback»(cordic_driver_t *cdp);
					'''
					cbfunc_list.add(f.callback)
				}
			}
		}
		return res
	}
	
	def String generateSr5e1_cordicExportedFunctions(Sr5e1_cordic component) {
		var header2 = ""
		for (f : component.configs.filter[enabled]) {
			header2 += '''

				void cordic_«f.name»(cordic_driver_t *cdp);
			'''
		}
		header2
	}
	
	def String generateSr5e1_cordicHeader(Sr5e1_cordic component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "cordic_cfg"

		if (error.severity == Diagnostic.OK) {

			'''
				«generateSr5e1_cordicCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#include <cordic.h>

				#ifdef __cplusplus
				extern "C" {
				#endif

				/* Exported callback function prototypes.*/
				«generateSr5e1_cordicCbfunc(component)»

				/* Exported configuration APIs.*/
				«generateSr5e1_cordicExportedFunctions(component)»
				
				#ifdef __cplusplus
				}
				#endif

				#endif /* _«filename.upper»_H_ */
			'''
		} else {
			'''
				«generateSr5e1_cordicCopyright()»

				#ifndef _«filename.upper»_H_
				#define _«filename.upper»_H_

				#error Invalid CORDIC Configuration

				#endif /* _«filename.upper»_H_ */
			'''
		}
	}
	
	def String generateSr5e1_cordicdata(Sr5e1_cordic component) {
		var res = ""

		for (f : component.configs.filter[enabled]) {
			if (f.drv_mode == drv_mode_t.CORDIC_DRV_MODE_DMA_SYNC || f.drv_mode == drv_mode_t.CORDIC_DRV_MODE_DMA_ASYNC) {
				res = res + '''

				static cordic_dma_conf_t «f.name»_dma_conf = {
					«f.dma_stream_wr_id.getName()»,
					«f.dma_stream_rd_id.getName()»,
					«f.dma_stream_bus_prio.getName()»,
					«f.dma_stream_irq_prio.getName()»
				};'''
			}
		}
		return (res)
	}
	
	def String generateSr5e1_cordicCode(Sr5e1_cordic component) {

		val error = Diagnostician.INSTANCE.validate(component)

		val filename = "cordic_cfg"
		var is_dma_enable = false

		if (error.severity == Diagnostic.OK) {
			for ( f : component.configs.filter[enabled]) {
				if (f.drv_mode == drv_mode_t.CORDIC_DRV_MODE_DMA_SYNC || f.drv_mode == drv_mode_t.CORDIC_DRV_MODE_DMA_ASYNC) {
			    		is_dma_enable = true;
			    }
			}
			'''
				«generateSr5e1_cordicCopyright()»

				#include <«filename».h>
				«IF (is_dma_enable == true)»
				#include <dma.h>
				«ENDIF»
				#include <irq.h>
				
				/* Internal configuration data.*/
				«generateSr5e1_cordicdata(component)»

				/* Exported configuration APIs.*/
				«FOR f : component.configs.filter[enabled]»
					
					void cordic_«f.name»(cordic_driver_t *cdp) {
					
						/* Configure cordic driver instance.*/
						(void)cordic_set_prio(cdp, «f.prio.getName()»);
						(void)cordic_set_drv_mode(cdp, «f.drv_mode.getName()»);
						(void)cordic_set_function(cdp, «f.func.getName()»);
						(void)cordic_set_precision(cdp, «f.prec.getName()»);
						(void)cordic_set_scale(cdp, «f.scale.getName()»);
						(void)cordic_set_res(cdp, «f.nres.getName()», «f.ressize.getName()»);
						(void)cordic_set_arg(cdp, «f.nargs.getName()», «f.argsize.getName()»);
						«IF (f.drv_mode == drv_mode_t.CORDIC_DRV_MODE_DMA_SYNC || f.drv_mode == drv_mode_t.CORDIC_DRV_MODE_DMA_ASYNC)»
						cordic_set_dma_conf(cdp, «'&'+f.name+'_dma_conf'»);
						«ENDIF»
						«IF (f.drv_mode != drv_mode_t.CORDIC_DRV_MODE_POLLING_SYNC && !f.callback.isNullOrEmpty())»
						(void)cordic_set_cb(cdp, «f.callback»);
						«ENDIF»
					}
				«ENDFOR»
			'''
		}
	}

	dispatch def String upper(boolean arg) {
		arg ? "TRUE" : "FALSE"
	}

	dispatch def String upper(String arg) {
		arg.toUpperCase(Locale.ENGLISH)
	}

}
