package sr5e1_power.util

import sr5e1_power.GeneralParameters
import sr5e1_power.PowerConsumption
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.Path
import org.eclipse.core.resources.IFile

class Sr5e1Helper {

	static public Sr5e1Helper instance = new Sr5e1Helper
	static String indent = ""

	private new() {
	}

	def void computeValues(GeneralParameters params, double tJunc, double lkg, double pMicro) {
		var debug = false
		if (debug) {
			System.out.println(indent + "T_Junc = " + tJunc);
			System.out.println(indent + "I_DD_LKG = " + lkg);
			System.out.println(indent + "P_Micro = " + pMicro);
		}
		var T_Junc = tJunc;
		var I_DD_LKG = lkg;
		var P_Micro = pMicro;
		var T_Amb = params.getAmbiant_temperature();
		T_Junc = T_Amb + pMicro * params.r_theta_JA / 1000.0;
		I_DD_LKG = params.computeIdd_leakeage(T_Junc)
		if (debug) {
			System.out.println(indent + "T junc=" + T_Junc);
			System.out.println(indent + "leakage=" + I_DD_LKG);
		}
		var I_DD_LV = params.idd_LV
		var I_Global = params.idd_Global
		var I_DD_HV_IO_MAIN = params.idd_HV_IO
		var I_DD_HV_ADC = params.idd_HV_ADC
		var I_DD_HV = I_DD_HV_IO_MAIN + I_DD_HV_ADC;
		var V_DD_LV = params.vdd_LV
		var V_DD_HV = params.vdd_HV
		var P_Ballast = (Double.parseDouble(V_DD_HV) - Double.parseDouble(V_DD_LV)) * (I_DD_LV + I_DD_LKG);
		var P_IO = getI_DD_HV_IO_5V() * getVdd_HV_IO_5V() + getI_DD_HV_IO_3V3() * getVDD_HV_IO_3V3();

		P_Micro = (I_DD_LKG + I_Global + I_DD_LV) * Double.parseDouble(V_DD_LV) + I_DD_HV * Double.parseDouble(V_DD_HV) + P_IO;

		if (Math.abs(tJunc - T_Junc) > 0.0001 || Math.abs(lkg - I_DD_LKG) > 0.0001 ||
			Math.abs(pMicro - P_Micro) > 0.0001) {
			val indentSave = indent
			indent = indent + " ".repeat(4)
			computeValues(params, T_Junc, I_DD_LKG, P_Micro);
			indent = indentSave
		} else {
			if (debug) {
				System.out.println(indent + "T_Junc = " + T_Junc);
				System.out.println(indent + "I_DD_LKG = " + I_DD_LKG);
				System.out.println(indent + "P_Micro = " + P_Micro);
			}
			// Limit junction temp to only 2 digits
			//params.setJunction_temperature(round(T_Junc))

			params.setIdd_Leakage(round(I_DD_LKG))

			params.setIdd_Global(round(I_Global))

			params.setP_micro(round(P_Micro))

//			setParameterValue(_i_dd_lv_Prop, round(I_DD_LV));
//			setParameterValue(_i_hv_io_main_Prop, round(I_DD_HV_IO_MAIN));
//			setParameterValue(_i_hv_adc_Prop, round(I_DD_HV_ADC));
//			_p_i_o_Prop.valueComputed(true);
//			setParameterValue(_p_i_o_Prop, round(P_IO));
			// try {
			// _p_i_o_Prop.valueComputed(true);
			// _p_i_o_Prop.setValue(round(P_IO));
			// } catch (SPC5Exception e) {
			// LogManager.getLogger().logError(e.getMessage());
			// }
			params.setP_ballast(round(P_Ballast))

//			params.setIdd_Total(round(I_DD_LV + I_DD_HV_IO_MAIN + I_DD_HV_ADC + I_Global + I_DD_LKG))
			// Remove leakage for the time being
			params.setIdd_Total(round(I_DD_LV + I_DD_HV_IO_MAIN + I_DD_HV_ADC + I_Global))

//			System.out
//					.println("______________________________________________________________________________________");
//			System.out.println("compute values done");
			indent = ""
			if (debug) {
				System.out.println(indent + "Total = " +
					round(I_DD_LV + I_DD_HV_IO_MAIN + I_DD_HV_ADC + I_Global + I_DD_LKG));
			}
		}
	}

	private def double round(double value) {
		Math.ceil(value * 100.0) / 100.0
	}

	def float getI_DD_HV_IO_3V3() {
		0.0f
	}

	def float getI_DD_HV_IO_5V() {
		0.0f
	}

	def float getVdd_HV_IO_5V() {
		0.0f
	}

	def float getVDD_HV_IO_3V3() {
		0.0f
	}

	/**
	 * Get the generated file from PinSettings
	 * @param pinSettings the root object
	 * @return the IFile corresponding to the pinSettings, or null if it does not exist
	 * 
	 */
	def IFile getGeneratedFile(PowerConsumption pinSettings, String ext) {
		val segments = pinSettings.eResource.URI.segmentsList
		val segCount = pinSettings.eResource.URI.segmentCount

		var destFileName = segments.get(segCount - 1).replaceAll("Sr5e1_power", ext)

		var uri = pinSettings.eResource().getURI();
		uri = pinSettings.eResource().getResourceSet().getURIConverter().normalize(uri);
		val scheme = uri.scheme();
		if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
			var platformResourcePath = new StringBuffer();
			var int j = 2;
			var size = uri.segmentCount()
			if (size > 3) {
//			platformResourcePath.append('/');
//			platformResourcePath.append(uri.segment(1));
				for (; j < size - 1; j++) {
					platformResourcePath.append('/');
					platformResourcePath.append(uri.segment(j));
				}
				platformResourcePath.append('/');
				platformResourcePath.append(destFileName);
				val file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(platformResourcePath.toString()));
				// file.toString.replace("L/", './data-gen/')
				file
			} else {
				platformResourcePath.append('/');
				platformResourcePath.append(uri.segment(1))
				platformResourcePath.append('/');
				platformResourcePath.append('./data-gen/')
				{
					val folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(
						new Path(platformResourcePath.toString()));
					// val folder = file.getRawLocation().makeAbsolute().toFile
					if (!folder.exists()) {
						folder.create(true, true, null)
					}
				}
				platformResourcePath.append(destFileName);
				val file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(platformResourcePath.toString()));
				// val fileStr = file.toString.replace("L/" + uri.segment(1) + "/", './data-gen/')
				// println(fileStr)
				file
			}
		} else {
			null
		}
	}
}
