package sr5e1_power.impl

import com.st.stellar.consumption.model.consumption.RunMode
import org.eclipse.xtext.EcoreUtil2
import sr5e1_power.MasterBlocks
import sr5e1_power.PowerConsumption

// This class overrides the generated class and will be instantiated by factory
class MasterBlocksImpl extends MMasterBlocksImpl implements MasterBlocks {

	new() {
		// Enabled by default
		enabled = true
	}

	override validChipModes() {
		"RUN SMART_POWER STANDBY"
	}

	override getChipMode() {
		val root = EcoreUtil2.getRootContainer(this) as PowerConsumption;
		val res = RunMode.get(root.general.chipMode)
		if( res === null) {
			RunMode.RUN
		} else {
			res
		}
	}
	
	override getChipModeString() {
		getChipMode.literal
	}

}
