package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.MConsumptionPackage
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.HRTIM
import sr5e1_power.Sr5e1_powerPackage

// This class overrides the generated class and will be instantiated by factory
class HRTIMImpl extends MHRTIMImpl implements HRTIM {
	new() {
		enabled = false
		IP_CLK = "300"
	}

	override describe(int indent) {
		if (isAllowed) {
			var res = "\t".repeat(indent) + this.id + " " + iP_CLK + " " +
				ConsumptionHelper.getUnit(MConsumptionPackage.eINSTANCE.peripheral_IP_CLK) + "\n"
			res += activeConfig.describe(indent + 1)
			res
		} else {
			""
		}
	}

	@DependsOn(source=Sr5e1_powerPackage.HRTIM__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.HRTIM__ENABLED,
		Sr5e1_powerPackage.HRTIM_CONFIG_RUN__PW_MFREQ,
		Sr5e1_powerPackage.HRTIM__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		val Cluster cluster = ConsumptionHelper.getCluster(this)
		if(cluster === null) return 0.0
		if (isAllowed) {
			switch (activeConfig.PWMfreq) {
				case E125_KHZ:
					return PowerUtils.round(29.0 * (multiplyFactor / 100.0))
				case E250_KHZ:
					return PowerUtils.round(29.0 * (multiplyFactor / 100.0))
				case E500_KHZ:
					return PowerUtils.round(29.0 * (multiplyFactor / 100.0))
			}
		}
		0.0
	}

	@DependsOn(source=Sr5e1_powerPackage.HRTIM__ALLOWED, dependencies=#[
		Sr5e1_powerPackage.HRTIM__ENABLED
		])
	override isAllowed() {
		super.isAllowed()
	}

}
