package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.HRTIM
import sr5e1_power.HRTIMConfigRun
import sr5e1_power.Sr5e1_powerPackage

// This class overrides the generated class and will be instantiated by factory
class HRTIMConfigRunImpl extends MHRTIMConfigRunImpl implements HRTIMConfigRun {
	new() {
		enabled = true
	}

	override getIDD_HV_IO() {
		0.0
	}

	override getIDD_HV() {
		0.0
	}

	override getIDD_HV_ADC() {
		0.0
	}

	@DependsOn(source=Sr5e1_powerPackage.HRTIM__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.HRTIM__ENABLED,
		Sr5e1_powerPackage.HRTIM__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		val Cluster cluster = ConsumptionHelper.getCluster(this)
		if(cluster === null) return 0.0
		if (isAllowed) {
			val parent = eContainer as HRTIM

			switch (PWMfreq) {
				case E125_KHZ:
					return PowerUtils.round(29.0 * (parent.multiplyFactor / 100.0))
				case E250_KHZ:
					return PowerUtils.round(29.0 * (parent.multiplyFactor / 100.0))
				case E500_KHZ:
					return PowerUtils.round(29.0 * (parent.multiplyFactor / 100.0))
			}
		}
		0.0
	}

	override describe(int indent) {
		val result = new StringBuilder("\t".repeat(indent))
		if (isAllowed) {
			result.append(" (Factor: ")
			result.append(multiplyFactor)
			result.append("%, ")
			result.append("PWM frequency: ")
			result.append(PWMfreq)
			result.append(')\n')
		}
		result.toString()
	}
}
