package sr5e1_power.impl

import com.google.inject.Inject
import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.RunMode
import com.st.stellar.consumption.model.consumption.SystemResource
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import java.util.Map
import org.eclipse.emf.ecore.util.EcoreUtil
import sr5e1_power.Device
import sr5e1_power.GeneralParameters
import sr5e1_power.PowerConsumption
import sr5e1_power.Sr5e1_powerPackage
import sr5e1_power.util.Sr5e1Helper

// This class overrides the generated class and will be instantiated by factory
class GeneralParametersImpl extends MGeneralParametersImpl implements GeneralParameters {

	new() {
	}

	override availableTemperatures() {
		"25°C,55°C,125°C,150°C"
	}

	override availableVoltages() {
		"3.3"
	}

	override availableLVVoltages() {
		"1.285"
	}

	override getDescription() {

		var StringBuffer buffer = new StringBuffer("")
		val rootContainer = EcoreUtil.getRootContainer(this)
		if (PowerConsumption.isInstance(rootContainer)) {
			val root = rootContainer as PowerConsumption
			buffer.append("Core Clusters:\n")
			val masters = root.masters
			for (sr : masters?.eContents.filter(SystemResource)) {
				if (sr.isAllowed) {
//				var StringBuffer config = new StringBuffer("")
//				val configs = sr.eContents.filter(Configuration)
//				println(configs.size)
//				for (cfg : configs) {
//					if (cfg.isAllowed) {
//						config.append(cfg.describe(2))
//					}
//				}
					buffer.append(sr.describe(1))
//				buffer.append(config)
				}
			}
			buffer.append("Peripheral Cluster:\n")
			for (sr : root.peripherals.eContents.filter(SystemResource)) {
				if (sr.isAllowed) {
//				var StringBuffer config = new StringBuffer("")
//			for (cfg : sr.eContents.filter(Configuration)) {
//				if (cfg.isAllowed) {
//					config.append(cfg.describe(2))
//				}
//			}
					buffer.append(sr.describe(1))
//				buffer.append(config)
				}
			}
		}
		buffer.toString
	}

	@Inject extension ConsumptionHelper

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_HV, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__CHIP_MODE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__JUNCTION_TEMPERATURE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__DEVICE
	])
	override getIdd_HV() {
		if(eContainer === null) return 0.0
		_consumptionHelper = ConsumptionHelper.instance
		val root = EcoreUtil.getRootContainer(this) as PowerConsumption
		root.globalIDD_HV
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_HV_ADC, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__CHIP_MODE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__JUNCTION_TEMPERATURE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__DEVICE
	])
	override getIdd_HV_ADC() {
		if(eContainer === null) return 0.0
		_consumptionHelper = ConsumptionHelper.instance
		val root = EcoreUtil.getRootContainer(this) as PowerConsumption
		root.globalIDD_HV_ADC
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_HV_IO, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__CHIP_MODE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__JUNCTION_TEMPERATURE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__DEVICE
	])
	override getIdd_HV_IO() {
		if(eContainer === null) return 0.0
		_consumptionHelper = ConsumptionHelper.instance
		val root = EcoreUtil.getRootContainer(this) as PowerConsumption
		root.globalIDD_HV_IO
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__CHIP_MODE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__JUNCTION_TEMPERATURE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__DEVICE
	])
	override getIdd_LV() {
		if(eContainer === null) return 0.0
		_consumptionHelper = ConsumptionHelper.instance
		val root = EcoreUtil.getRootContainer(this) as PowerConsumption
		val res = PowerUtils.round(root.globalIDD_LV)
		res
	}

	static boolean computing = false

	@Inject extension Sr5e1Helper

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_TOTAL, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_GLOBAL,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_HV,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_HV_ADC,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_HV_IO,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_LEAKAGE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_LV
	])
	override getIdd_Total() {
		if (!computing) {
			_sr5e1Helper = Sr5e1Helper.instance

			computing = true
			computeValues(0.0, 0.0, 0.0);
			computing = false
		}
		return idd_Total;
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__PHV, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_FACTOR,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_HV
	])
	override getP_HV() {
		PowerUtils.round(getIdd_HV * Double.parseDouble(getVdd_HV) * ((100.0 + getVdd_HV_factor) / 100.0))
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_COMPUTED, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_FACTOR
	])
	override getVdd_HV_computed() {
		PowerUtils.round(Double.parseDouble(getVdd_HV) * ((100.0 + getVdd_HV_factor) / 100.0))
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__PHV_IO, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_IO,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_IO_FACTOR,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_HV_IO
	])
	override getP_HV_IO() {
		PowerUtils.round(getIdd_HV_IO * Double.parseDouble(getVdd_HV_IO) * ((100.0 + getVdd_HV_IO_factor) / 100.0))
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_IO_COMPUTED, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_IO,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_IO_FACTOR
	])
	override getVdd_HV_IO_computed() {
		PowerUtils.round(Double.parseDouble(getVdd_HV_IO) * ((100.0 + getVdd_HV_IO_factor) / 100.0))
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__PHV_ADC, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_IO,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_IO_FACTOR,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_HV_IO
	])
	override getP_HV_ADC() {
		getIdd_HV_ADC * Double.parseDouble(getVdd_HV_ADC) * ((100.0 + getVdd_HV_ADC_factor) / 100.0)
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_ADC_COMPUTED, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_ADC,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_ADC_FACTOR
	])
	override getVdd_HV_ADC_computed() {
		PowerUtils.round(Double.parseDouble(getVdd_HV_ADC) * ((100.0 + getVdd_HV_ADC_factor) / 100.0))
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__PLV, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_LV,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_LV_FACTOR,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_LV
	])
	override getP_LV() {
		PowerUtils.round(getIdd_LV * Double.parseDouble(getVdd_LV) * ((100.0 + getVdd_LV_factor) / 100.0))
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_LV_COMPUTED, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_LV,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_LV_FACTOR
	])
	override getVdd_LV_computed() {
		PowerUtils.round(Double.parseDouble(getVdd_LV) * ((100.0 + getVdd_LV_factor) / 100.0))
	}

	static Map<RunMode, Map<Device, Map<String, Double>>> leakages = #{
		RunMode.RUN -> #{
			Device.SR5E1 -> #{"25°C" -> 0.0, "55°C" -> 150.0, "125°C" -> 1320.0, "150°C" -> 2900.0}
		},
		RunMode.SMART_POWER -> #{
			Device.SR5E1 -> #{"25°C" -> 20.0, "55°C" -> 30.0, "125°C" -> 55.0, "150°C" -> 100.0}
		},
		RunMode.STANDBY -> #{Device.SR5E1 -> #{"25°C" -> 0.300, "55°C" -> 0.640, "125°C" -> 7.5, "150°C" -> 10.3}}
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__PLV_LEAKAGE, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_LV,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_LV_FACTOR,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_LV
	])
	override getP_LV_Leakage() {
		PowerUtils.round(getIdd_Leakage * Double.parseDouble(getVdd_LV) * ((100.0 + getVdd_LV_factor) / 100.0))
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__IDD_LEAKAGE, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__CHIP_MODE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__DEVICE,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__JUNCTION_TEMPERATURE
	])
	override getIdd_Leakage() {
		val mode = RunMode.get(getChipMode)
		val modeLeakages = leakages.get(mode)
		if (modeLeakages !== null) {
			val devLeakages = modeLeakages.get(getDevice)
			val leakage = devLeakages.get(getJunction_temperature)
			leakage
		} else {
			0.0
		}
	}

	@DependsOn(source=Sr5e1_powerPackage.GENERAL_PARAMETERS__PTOTAL, dependencies=#[
		Sr5e1_powerPackage.GENERAL_PARAMETERS__PHV,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_FACTOR,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__PHV_ADC,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_ADC_FACTOR,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__PHV_IO,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_HV_IO_FACTOR,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__PLV,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__VDD_LV_FACTOR,
		Sr5e1_powerPackage.GENERAL_PARAMETERS__PLV_LEAKAGE
	])
	override getP_Total() {
		PowerUtils.round(getP_HV + getP_HV_IO + getP_HV_ADC + getP_LV + getP_LV_Leakage)
	}

	override availableChipModes() {
		validChipModes.get(getDevice)
	}

	static Map<Device, String> validChipModes = #{
		Device.SR5E1 -> "RUN"
	}

	override getChipMode() {
		val mode = super.chipMode
		if (mode === null || !availableChipModes.contains(mode)) {
			return RunMode.RUN.literal
		}
		super.chipMode
	}

}
