package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.DSPI
import sr5e1_power.Sr5e1_powerPackage

// This class overrides the generated class and will be instantiated by factory
class DSPIImpl extends MDSPIImpl implements DSPI {
	new() {
		enabled = false
		IP_CLK = "100"
	}

	override describe(int indent) {
		if (isAllowed) {
			var res = "\t".repeat(indent) + this.id + "\n"
			res += activeConfig.describe(indent + 1)
			res
		} else {
			""
		}
	}
	
	@DependsOn(source=Sr5e1_powerPackage.DSPI__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.DSPI__ENABLED,
		Sr5e1_powerPackage.DSPI_CONFIG__BAUD_RATE,
		Sr5e1_powerPackage.DSPI__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		val Cluster cluster = ConsumptionHelper.getCluster(this)
		if(cluster === null) return 0.0
		if (isAllowed) {
			switch (activeConfig.baudRate) {
				case E5M_HZ:
					return PowerUtils.round(3.0 * (multiplyFactor / 100.0))
				case E10M_HZ:
					return PowerUtils.round(3.0 * (multiplyFactor / 100.0))
				case E20M_HZ:
					return PowerUtils.round(3.0 * (multiplyFactor / 100.0))
			}
		}
		0.0
	}
	
	@DependsOn(source=Sr5e1_powerPackage.DSPI__ALLOWED, dependencies=#[
		Sr5e1_powerPackage.DSPI__ENABLED
		])
	override isAllowed() {
		super.isAllowed()
	}
	
}
