/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power.util;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.xbase.lib.Exceptions;
import sr5e1_power.GeneralParameters;
import sr5e1_power.PowerConsumption;

public class Sr5e1Helper {
    public static Sr5e1Helper instance = new Sr5e1Helper();
    private static String indent = "";

    private Sr5e1Helper() {
    }

    public void computeValues(GeneralParameters params, double tJunc, double lkg, double pMicro) {
        double _plus_2;
        double _plus;
        boolean debug = false;
        if (debug) {
            System.out.println(indent + "T_Junc = " + Double.valueOf(tJunc));
            System.out.println(indent + "I_DD_LKG = " + Double.valueOf(lkg));
            System.out.println(indent + "P_Micro = " + Double.valueOf(pMicro));
        }
        double T_Junc = tJunc;
        double I_DD_LKG = lkg;
        double P_Micro = pMicro;
        double T_Amb = params.getAmbiant_temperature();
        double _r_theta_JA = params.getR_theta_JA();
        double _multiply = pMicro * _r_theta_JA;
        double _divide = _multiply / 1000.0;
        T_Junc = _plus = T_Amb + _divide;
        I_DD_LKG = params.computeIdd_leakeage(T_Junc);
        if (debug) {
            System.out.println(indent + "T junc=" + Double.valueOf(T_Junc));
            System.out.println(indent + "leakage=" + Double.valueOf(I_DD_LKG));
        }
        double I_DD_LV = params.getIdd_LV();
        double I_Global = params.getIdd_Global();
        double I_DD_HV_IO_MAIN = params.getIdd_HV_IO();
        double I_DD_HV_ADC = params.getIdd_HV_ADC();
        double I_DD_HV = I_DD_HV_IO_MAIN + I_DD_HV_ADC;
        String V_DD_LV = params.getVdd_LV();
        String V_DD_HV = params.getVdd_HV();
        double _parseDouble = Double.parseDouble(V_DD_HV);
        double _parseDouble_1 = Double.parseDouble(V_DD_LV);
        double _minus = _parseDouble - _parseDouble_1;
        double P_Ballast = _minus * (I_DD_LV + I_DD_LKG);
        float _i_DD_HV_IO_5V = this.getI_DD_HV_IO_5V();
        float _vdd_HV_IO_5V = this.getVdd_HV_IO_5V();
        float _multiply_1 = _i_DD_HV_IO_5V * _vdd_HV_IO_5V;
        float _i_DD_HV_IO_3V3 = this.getI_DD_HV_IO_3V3();
        float _vDD_HV_IO_3V3 = this.getVDD_HV_IO_3V3();
        float _multiply_2 = _i_DD_HV_IO_3V3 * _vDD_HV_IO_3V3;
        float P_IO = _multiply_1 + _multiply_2;
        double _parseDouble_2 = Double.parseDouble(V_DD_LV);
        double _multiply_3 = (I_DD_LKG + I_Global + I_DD_LV) * _parseDouble_2;
        double _parseDouble_3 = Double.parseDouble(V_DD_HV);
        double _multiply_4 = I_DD_HV * _parseDouble_3;
        double _plus_1 = _multiply_3 + _multiply_4;
        P_Micro = _plus_2 = _plus_1 + (double)P_IO;
        if (Math.abs(tJunc - T_Junc) > 1.0E-4 || Math.abs(lkg - I_DD_LKG) > 1.0E-4 || Math.abs(pMicro - P_Micro) > 1.0E-4) {
            String indentSave = indent;
            String _repeat = " ".repeat(4);
            String _plus_3 = indent + _repeat;
            indent = _plus_3;
            this.computeValues(params, T_Junc, I_DD_LKG, P_Micro);
            indent = indentSave;
        } else {
            if (debug) {
                System.out.println(indent + "T_Junc = " + Double.valueOf(T_Junc));
                System.out.println(indent + "I_DD_LKG = " + Double.valueOf(I_DD_LKG));
                System.out.println(indent + "P_Micro = " + Double.valueOf(P_Micro));
            }
            params.setIdd_Leakage(this.round(I_DD_LKG));
            params.setIdd_Global(this.round(I_Global));
            params.setP_micro(this.round(P_Micro));
            params.setP_ballast(this.round(P_Ballast));
            params.setIdd_Total(this.round(I_DD_LV + I_DD_HV_IO_MAIN + I_DD_HV_ADC + I_Global));
            indent = "";
            if (debug) {
                double _round = this.round(I_DD_LV + I_DD_HV_IO_MAIN + I_DD_HV_ADC + I_Global + I_DD_LKG);
                String _plus_4 = indent + "Total = " + Double.valueOf(_round);
                System.out.println(_plus_4);
            }
        }
    }

    private double round(double value) {
        double _ceil = Math.ceil(value * 100.0);
        return _ceil / 100.0;
    }

    public float getI_DD_HV_IO_3V3() {
        return 0.0f;
    }

    public float getI_DD_HV_IO_5V() {
        return 0.0f;
    }

    public float getVdd_HV_IO_5V() {
        return 0.0f;
    }

    public float getVDD_HV_IO_3V3() {
        return 0.0f;
    }

    public IFile getGeneratedFile(PowerConsumption pinSettings, String ext) {
        try {
            IFile _xblockexpression = null;
            List segments = pinSettings.eResource().getURI().segmentsList();
            int segCount = pinSettings.eResource().getURI().segmentCount();
            String destFileName = ((String)segments.get(segCount - 1)).replaceAll("Sr5e1_power", ext);
            URI uri = pinSettings.eResource().getURI();
            uri = pinSettings.eResource().getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            IFile _xifexpression = null;
            if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
                IFile _xblockexpression_1 = null;
                StringBuffer platformResourcePath = new StringBuffer();
                int size = uri.segmentCount();
                IFile _xifexpression_1 = null;
                if (size > 3) {
                    IFile file;
                    IFile _xblockexpression_2 = null;
                    for (int j = 2; j < size - 1; ++j) {
                        platformResourcePath.append("/");
                        platformResourcePath.append(uri.segment(j));
                    }
                    platformResourcePath.append("/");
                    platformResourcePath.append(destFileName);
                    IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                    String _string = platformResourcePath.toString();
                    Path _path = new Path(_string);
                    _xifexpression_1 = _xblockexpression_2 = (file = _root.getFile((IPath)_path));
                } else {
                    IFile file;
                    boolean _not;
                    IFile _xblockexpression_3 = null;
                    platformResourcePath.append("/");
                    platformResourcePath.append(uri.segment(1));
                    platformResourcePath.append("/");
                    platformResourcePath.append("./data-gen/");
                    IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                    String _string = platformResourcePath.toString();
                    Path _path = new Path(_string);
                    IFolder folder = _root.getFolder((IPath)_path);
                    boolean _exists = folder.exists();
                    boolean bl = _not = !_exists;
                    if (_not) {
                        folder.create(true, true, null);
                    }
                    platformResourcePath.append(destFileName);
                    _root = ResourcesPlugin.getWorkspace().getRoot();
                    _string = platformResourcePath.toString();
                    _path = new Path(_string);
                    _xifexpression_1 = _xblockexpression_3 = (file = _root.getFile((IPath)_path));
                }
                _xifexpression = _xblockexpression_1 = _xifexpression_1;
            } else {
                _xifexpression = null;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

