/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power.impl;

import com.st.stellar.component.DependsOn;
import com.st.stellar.consumption.model.consumption.Cluster;
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper;
import org.eclipse.emf.ecore.EObject;
import sr5e1_power.UART;
import sr5e1_power.UARTBaudRate;
import sr5e1_power.impl.MUARTImpl;
import sr5e1_power.impl.PowerUtils;

public class UARTImpl
extends MUARTImpl
implements UART {
    public UARTImpl() {
        this.enabled = false;
        this.setIP_CLK("40");
    }

    @DependsOn(source=10, dependencies={3, 11, 4})
    public double getIDD_LV() {
        UARTBaudRate _baudRate;
        double _xblockexpression = 0.0;
        Cluster cluster = ConsumptionHelper.getCluster((EObject)this);
        if (cluster == null) {
            return 0.0;
        }
        boolean _isAllowed = this.isAllowed();
        if (_isAllowed && (_baudRate = this.activeConfig.getBaudRate()) != null) {
            switch (_baudRate) {
                case E9600_KBPS: {
                    return PowerUtils.round(1.0 * (this.multiplyFactor / 100.0));
                }
                case E38400_KBPS: {
                    return PowerUtils.round(2.0 * (this.multiplyFactor / 100.0));
                }
                case E921600_KBPS: {
                    return PowerUtils.round(2.0 * (this.multiplyFactor / 100.0));
                }
            }
        }
        _xblockexpression = 0.0;
        return _xblockexpression;
    }

    public String describe(int indent) {
        Object _xifexpression = null;
        boolean _isAllowed = this.isAllowed();
        if (_isAllowed) {
            String res;
            String _xblockexpression = null;
            String _repeat = "\t".repeat(indent);
            String _plus = _repeat + this.id;
            String _res = res = _plus + "\n";
            String _describe = this.activeConfig.describe(indent + 1);
            _xblockexpression = res = _res + _describe;
            _xifexpression = _xblockexpression;
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    @DependsOn(source=5, dependencies={3})
    public boolean isAllowed() {
        return super.isAllowed();
    }
}

