/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power.impl;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.st.stellar.component.DependsOn;
import com.st.stellar.consumption.model.consumption.RunMode;
import com.st.stellar.consumption.model.consumption.SystemResource;
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import sr5e1_power.Device;
import sr5e1_power.GeneralParameters;
import sr5e1_power.MasterBlocks;
import sr5e1_power.PowerConsumption;
import sr5e1_power.impl.MGeneralParametersImpl;
import sr5e1_power.impl.PowerUtils;
import sr5e1_power.util.Sr5e1Helper;

public class GeneralParametersImpl
extends MGeneralParametersImpl
implements GeneralParameters {
    @Inject
    @Extension
    private ConsumptionHelper _consumptionHelper;
    private static boolean computing = false;
    @Inject
    @Extension
    private Sr5e1Helper _sr5e1Helper;
    private static Map<RunMode, Map<Device, Map<String, Double>>> leakages = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)RunMode.RUN, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)((Object)Device.SR5E1), Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"25\u00b0C", (Object)0.0), Pair.of((Object)"55\u00b0C", (Object)150.0), Pair.of((Object)"125\u00b0C", (Object)1320.0), Pair.of((Object)"150\u00b0C", (Object)2900.0)})))}))), Pair.of((Object)RunMode.SMART_POWER, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)((Object)Device.SR5E1), Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"25\u00b0C", (Object)20.0), Pair.of((Object)"55\u00b0C", (Object)30.0), Pair.of((Object)"125\u00b0C", (Object)55.0), Pair.of((Object)"150\u00b0C", (Object)100.0)})))}))), Pair.of((Object)RunMode.STANDBY, Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)((Object)Device.SR5E1), Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"25\u00b0C", (Object)0.3), Pair.of((Object)"55\u00b0C", (Object)0.64), Pair.of((Object)"125\u00b0C", (Object)7.5), Pair.of((Object)"150\u00b0C", (Object)10.3)})))})))}));
    private static Map<Device, String> validChipModes = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)((Object)Device.SR5E1), (Object)"RUN")}));

    @Override
    public String availableTemperatures() {
        return "25\u00b0C,55\u00b0C,125\u00b0C,150\u00b0C";
    }

    @Override
    public String availableVoltages() {
        return "3.3";
    }

    @Override
    public String availableLVVoltages() {
        return "1.285";
    }

    @Override
    public String getDescription() {
        String _xblockexpression = null;
        StringBuffer buffer = new StringBuffer("");
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)this);
        boolean _isInstance = PowerConsumption.class.isInstance(rootContainer);
        if (_isInstance) {
            PowerConsumption root = (PowerConsumption)rootContainer;
            buffer.append("Core Clusters:\n");
            MasterBlocks masters = root.getMasters();
            EList _eContents = null;
            if (masters != null) {
                _eContents = masters.eContents();
            }
            Iterable _filter = Iterables.filter((Iterable)_eContents, SystemResource.class);
            for (SystemResource sr : _filter) {
                boolean _isAllowed = sr.isAllowed();
                if (!_isAllowed) continue;
                buffer.append(sr.describe(1));
            }
            buffer.append("Peripheral Cluster:\n");
            Iterable _filter_1 = Iterables.filter((Iterable)root.getPeripherals().eContents(), SystemResource.class);
            for (SystemResource sr_1 : _filter_1) {
                boolean _isAllowed_1 = sr_1.isAllowed();
                if (!_isAllowed_1) continue;
                buffer.append(sr_1.describe(1));
            }
        }
        _xblockexpression = buffer.toString();
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=17, dependencies={34, 24, 33})
    public double getIdd_HV() {
        double _xblockexpression = 0.0;
        if (this.eContainer == null) {
            return 0.0;
        }
        this._consumptionHelper = ConsumptionHelper.instance;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)this);
        PowerConsumption root = (PowerConsumption)_rootContainer;
        _xblockexpression = this._consumptionHelper.getGlobalIDD_HV((EObject)root);
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=19, dependencies={34, 24, 33})
    public double getIdd_HV_ADC() {
        double _xblockexpression = 0.0;
        if (this.eContainer == null) {
            return 0.0;
        }
        this._consumptionHelper = ConsumptionHelper.instance;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)this);
        PowerConsumption root = (PowerConsumption)_rootContainer;
        _xblockexpression = this._consumptionHelper.getGlobalIDD_HV_ADC((EObject)root);
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=18, dependencies={34, 24, 33})
    public double getIdd_HV_IO() {
        double _xblockexpression = 0.0;
        if (this.eContainer == null) {
            return 0.0;
        }
        this._consumptionHelper = ConsumptionHelper.instance;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)this);
        PowerConsumption root = (PowerConsumption)_rootContainer;
        _xblockexpression = this._consumptionHelper.getGlobalIDD_HV_IO((EObject)root);
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=20, dependencies={34, 24, 33})
    public double getIdd_LV() {
        double res;
        double _xblockexpression = 0.0;
        if (this.eContainer == null) {
            return 0.0;
        }
        this._consumptionHelper = ConsumptionHelper.instance;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)this);
        PowerConsumption root = (PowerConsumption)_rootContainer;
        _xblockexpression = res = PowerUtils.round(this._consumptionHelper.getGlobalIDD_LV((EObject)root));
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=23, dependencies={21, 17, 19, 18, 22, 20})
    public double getIdd_Total() {
        if (!computing) {
            this._sr5e1Helper = Sr5e1Helper.instance;
            computing = true;
            this._sr5e1Helper.computeValues(this, 0.0, 0.0, 0.0);
            computing = false;
        }
        return this.idd_Total;
    }

    @Override
    @DependsOn(source=27, dependencies={3, 4, 17})
    public double getP_HV() {
        double _idd_HV = this.getIdd_HV();
        double _parseDouble = Double.parseDouble(this.getVdd_HV());
        double _multiply = _idd_HV * _parseDouble;
        double _vdd_HV_factor = this.getVdd_HV_factor();
        double _plus = 100.0 + _vdd_HV_factor;
        double _divide = _plus / 100.0;
        double _multiply_1 = _multiply * _divide;
        return PowerUtils.round(_multiply_1);
    }

    @Override
    @DependsOn(source=5, dependencies={3, 4})
    public double getVdd_HV_computed() {
        double _parseDouble = Double.parseDouble(this.getVdd_HV());
        double _vdd_HV_factor = this.getVdd_HV_factor();
        double _plus = 100.0 + _vdd_HV_factor;
        double _divide = _plus / 100.0;
        double _multiply = _parseDouble * _divide;
        return PowerUtils.round(_multiply);
    }

    @Override
    @DependsOn(source=28, dependencies={6, 7, 18})
    public double getP_HV_IO() {
        double _idd_HV_IO = this.getIdd_HV_IO();
        double _parseDouble = Double.parseDouble(this.getVdd_HV_IO());
        double _multiply = _idd_HV_IO * _parseDouble;
        double _vdd_HV_IO_factor = this.getVdd_HV_IO_factor();
        double _plus = 100.0 + _vdd_HV_IO_factor;
        double _divide = _plus / 100.0;
        double _multiply_1 = _multiply * _divide;
        return PowerUtils.round(_multiply_1);
    }

    @Override
    @DependsOn(source=8, dependencies={6, 7})
    public double getVdd_HV_IO_computed() {
        double _parseDouble = Double.parseDouble(this.getVdd_HV_IO());
        double _vdd_HV_IO_factor = this.getVdd_HV_IO_factor();
        double _plus = 100.0 + _vdd_HV_IO_factor;
        double _divide = _plus / 100.0;
        double _multiply = _parseDouble * _divide;
        return PowerUtils.round(_multiply);
    }

    @Override
    @DependsOn(source=29, dependencies={6, 7, 18})
    public double getP_HV_ADC() {
        double _idd_HV_ADC = this.getIdd_HV_ADC();
        double _parseDouble = Double.parseDouble(this.getVdd_HV_ADC());
        double _multiply = _idd_HV_ADC * _parseDouble;
        double _vdd_HV_ADC_factor = this.getVdd_HV_ADC_factor();
        double _plus = 100.0 + _vdd_HV_ADC_factor;
        double _divide = _plus / 100.0;
        return _multiply * _divide;
    }

    @Override
    @DependsOn(source=11, dependencies={9, 10})
    public double getVdd_HV_ADC_computed() {
        double _parseDouble = Double.parseDouble(this.getVdd_HV_ADC());
        double _vdd_HV_ADC_factor = this.getVdd_HV_ADC_factor();
        double _plus = 100.0 + _vdd_HV_ADC_factor;
        double _divide = _plus / 100.0;
        double _multiply = _parseDouble * _divide;
        return PowerUtils.round(_multiply);
    }

    @Override
    @DependsOn(source=30, dependencies={12, 13, 20})
    public double getP_LV() {
        double _idd_LV = this.getIdd_LV();
        double _parseDouble = Double.parseDouble(this.getVdd_LV());
        double _multiply = _idd_LV * _parseDouble;
        double _vdd_LV_factor = this.getVdd_LV_factor();
        double _plus = 100.0 + _vdd_LV_factor;
        double _divide = _plus / 100.0;
        double _multiply_1 = _multiply * _divide;
        return PowerUtils.round(_multiply_1);
    }

    @Override
    @DependsOn(source=14, dependencies={12, 13})
    public double getVdd_LV_computed() {
        double _parseDouble = Double.parseDouble(this.getVdd_LV());
        double _vdd_LV_factor = this.getVdd_LV_factor();
        double _plus = 100.0 + _vdd_LV_factor;
        double _divide = _plus / 100.0;
        double _multiply = _parseDouble * _divide;
        return PowerUtils.round(_multiply);
    }

    @Override
    @DependsOn(source=31, dependencies={12, 13, 20})
    public double getP_LV_Leakage() {
        double _idd_Leakage = this.getIdd_Leakage();
        double _parseDouble = Double.parseDouble(this.getVdd_LV());
        double _multiply = _idd_Leakage * _parseDouble;
        double _vdd_LV_factor = this.getVdd_LV_factor();
        double _plus = 100.0 + _vdd_LV_factor;
        double _divide = _plus / 100.0;
        double _multiply_1 = _multiply * _divide;
        return PowerUtils.round(_multiply_1);
    }

    @Override
    @DependsOn(source=22, dependencies={34, 33, 24})
    public double getIdd_Leakage() {
        Double _xblockexpression = null;
        RunMode mode = RunMode.get((String)this.getChipMode());
        Map<Device, Map<String, Double>> modeLeakages = leakages.get(mode);
        Double _xifexpression = null;
        if (modeLeakages != null) {
            Double leakage;
            Double _xblockexpression_1 = null;
            Map<String, Double> devLeakages = modeLeakages.get((Object)this.getDevice());
            _xifexpression = _xblockexpression_1 = (leakage = devLeakages.get(this.getJunction_temperature()));
        } else {
            _xifexpression = 0.0;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @DependsOn(source=32, dependencies={27, 4, 29, 10, 28, 7, 30, 13, 31})
    public double getP_Total() {
        double _p_HV = this.getP_HV();
        double _p_HV_IO = this.getP_HV_IO();
        double _plus = _p_HV + _p_HV_IO;
        double _p_HV_ADC = this.getP_HV_ADC();
        double _plus_1 = _plus + _p_HV_ADC;
        double _p_LV = this.getP_LV();
        double _plus_2 = _plus_1 + _p_LV;
        double _p_LV_Leakage = this.getP_LV_Leakage();
        double _plus_3 = _plus_2 + _p_LV_Leakage;
        return PowerUtils.round(_plus_3);
    }

    @Override
    public String availableChipModes() {
        return validChipModes.get((Object)this.getDevice());
    }

    @Override
    public String getChipMode() {
        String _xblockexpression = null;
        String mode = this.chipMode;
        if (mode == null || !this.availableChipModes().contains(mode)) {
            return RunMode.RUN.getLiteral();
        }
        _xblockexpression = this.chipMode;
        return _xblockexpression;
    }
}

