/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UARTBaudRate implements Enumerator
{
    E9600_KBPS(0, "E9600Kbps", "9600 Kbps"),
    E38400_KBPS(1, "E38400Kbps", "38400 Kbps"),
    E921600_KBPS(2, "E921600Kbps", "921600 Kbps");

    public static final int E9600_KBPS_VALUE = 0;
    public static final int E38400_KBPS_VALUE = 1;
    public static final int E921600_KBPS_VALUE = 2;
    private static final UARTBaudRate[] VALUES_ARRAY;
    public static final List<UARTBaudRate> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static UARTBaudRate get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            UARTBaudRate result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static UARTBaudRate getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            UARTBaudRate result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static UARTBaudRate get(int value) {
        switch (value) {
            case 0: {
                return E9600_KBPS;
            }
            case 1: {
                return E38400_KBPS;
            }
            case 2: {
                return E921600_KBPS;
            }
        }
        return null;
    }

    private UARTBaudRate(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new UARTBaudRate[]{E9600_KBPS, E38400_KBPS, E921600_KBPS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

