/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PWMFrequency implements Enumerator
{
    E125_KHZ(0, "E125Khz", "125 Khz"),
    E250_KHZ(1, "E250Khz", "250 Khz"),
    E500_KHZ(2, "E500Khz", "500 Khz");

    public static final int E125_KHZ_VALUE = 0;
    public static final int E250_KHZ_VALUE = 1;
    public static final int E500_KHZ_VALUE = 2;
    private static final PWMFrequency[] VALUES_ARRAY;
    public static final List<PWMFrequency> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static PWMFrequency get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            PWMFrequency result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static PWMFrequency getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            PWMFrequency result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static PWMFrequency get(int value) {
        switch (value) {
            case 0: {
                return E125_KHZ;
            }
            case 1: {
                return E250_KHZ;
            }
            case 2: {
                return E500_KHZ;
            }
        }
        return null;
    }

    private PWMFrequency(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new PWMFrequency[]{E125_KHZ, E250_KHZ, E500_KHZ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

