/*
 * Decompiled with CFR 0.152.
 */
package sr5e1_power;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Activation implements Enumerator
{
    LOW(0, "Low", "Low"),
    TYP(1, "Typ", "Typ"),
    MAX(2, "Max", "Max");

    public static final int LOW_VALUE = 0;
    public static final int TYP_VALUE = 1;
    public static final int MAX_VALUE = 2;
    private static final Activation[] VALUES_ARRAY;
    public static final List<Activation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Activation get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Activation result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Activation getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Activation result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Activation get(int value) {
        switch (value) {
            case 0: {
                return LOW;
            }
            case 1: {
                return TYP;
            }
            case 2: {
                return MAX;
            }
        }
        return null;
    }

    private Activation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Activation[]{LOW, TYP, MAX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

