package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.Sr5e1_powerPackage
import sr5e1_power.UART

// This class overrides the generated class and will be instantiated by factory
class UARTImpl extends MUARTImpl implements UART {
	new() {
		enabled = false
		IP_CLK = "40"
	}

	@DependsOn(source=Sr5e1_powerPackage.UART__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.UART__ENABLED,
		Sr5e1_powerPackage.UART_CONFIG__BAUD_RATE,
		Sr5e1_powerPackage.UART__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		val Cluster cluster = ConsumptionHelper.getCluster(this)
		if(cluster === null) return 0.0
		if (isAllowed) {
			switch (activeConfig.baudRate) {
				case E9600_KBPS:
					return PowerUtils.round(1.0 * (multiplyFactor / 100.0))
				case E38400_KBPS:
					return PowerUtils.round(2.0 * (multiplyFactor / 100.0))
				case E921600_KBPS:
					return PowerUtils.round(2.0 * (multiplyFactor / 100.0))
			}
		}
		0.0
	}

	override describe(int indent) {
		if (isAllowed) {
			var res = "\t".repeat(indent) + this.id + "\n"
			res += activeConfig.describe(indent + 1)
			res
		} else {
			""
		}
	}
	
	@DependsOn(source=Sr5e1_powerPackage.UART__ALLOWED, dependencies=#[
		Sr5e1_powerPackage.UART__ENABLED
		])
	override isAllowed() {
		super.isAllowed()
	}
	
}
