package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.MConsumptionPackage
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.SDADC
import sr5e1_power.Sr5e1_powerPackage

// This class overrides the generated class and will be instantiated by factory
class SDADCImpl extends MSDADCImpl implements SDADC {

	new() {
		enabled = false

		IP_CLK = "5"
	}


	@DependsOn(source=Sr5e1_powerPackage.MODULATOR_CONFIG__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.MODULATOR_CONFIG__ENABLED,
		Sr5e1_powerPackage.SDADC__IP_CLK,
		Sr5e1_powerPackage.MODULATOR_CONFIG__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		super.getIDD_LV()
	}
	
	override describe(int indent) {
		if (isAllowed) {
			val result = new StringBuilder("\t".repeat(indent) + this.id + " " + iP_CLK.toString + " " +
				ConsumptionHelper.getUnit(MConsumptionPackage.eINSTANCE.peripheral_IP_CLK))
			result.append("\n")
			result.append(modulatorConfig.describe(indent + 1))
			result.toString()
		} else {
			""
		}
	}

	@DependsOn(source=Sr5e1_powerPackage.SDADC__ALLOWED, dependencies=#[
		Sr5e1_powerPackage.SDADC__ENABLED
		])
	override isAllowed() {
		super.isAllowed()
	}

}
