package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.MConsumptionPackage
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.SARADC_12bit
import sr5e1_power.Sr5e1_powerPackage

// This class overrides the generated class and will be instantiated by factory
class SARADC_12bitImpl extends MSARADC_12bitImpl implements SARADC_12bit {
	new() {
		enabled = false
		IP_CLK = "10"
	}

	@DependsOn(source=Sr5e1_powerPackage.SARADC_12BIT__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.SARADC_12BIT__ENABLED,
		Sr5e1_powerPackage.SARADC_12BIT__IP_CLK,
		Sr5e1_powerPackage.SARADC_12BIT__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		super.getIDD_LV()
	}

	override describe(int indent) {
		if (isAllowed) {
			var res = "\t".repeat(indent) + this.id + " " + iP_CLK + " " +
				ConsumptionHelper.getUnit(MConsumptionPackage.eINSTANCE.peripheral_IP_CLK) + "\n"
			res += activeConfig.describe(indent + 1)
			res
		} else {
			""
		}
	}

	@DependsOn(source=Sr5e1_powerPackage.SARADC_12BIT__ALLOWED, dependencies=#[
		Sr5e1_powerPackage.SARADC_12BIT__ENABLED
		])
	override isAllowed() {
		super.isAllowed()
	}

}
