package sr5e1_power.impl

import com.st.stellar.component.DependsOn
import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.SARADCConfig
import sr5e1_power.SARADC_12bit
import sr5e1_power.Sr5e1_powerPackage

// This class overrides the generated class and will be instantiated by factory
class SARADCConfigImpl extends MSARADCConfigImpl implements SARADCConfig {
	new() {
		enabled = true
	}

	override getIDD_HV_IO() {
		0.0
	}

	override getIDD_HV() {
		0.0
	}

	override getIDD_HV_ADC() {
		0.0
	}

	@DependsOn(source=Sr5e1_powerPackage.SARADC_12BIT__IDD_LV, dependencies=#[
		Sr5e1_powerPackage.SARADC_12BIT__ENABLED,
		Sr5e1_powerPackage.SARADC_12BIT__IP_CLK,
		Sr5e1_powerPackage.SARADC_12BIT__MULTIPLY_FACTOR
	])
	override getIDD_LV() {
		if (isAllowed) {
			val Cluster cluster = ConsumptionHelper.getCluster(this)
			if(cluster === null) return 0.0
			val parent = eContainer as SARADC_12bit
			switch (parent.IP_CLK) {
				case "10": {
					return PowerUtils.round(4.0 * (parent.multiplyFactor / 100.0))
				}
				case "20": {
					return PowerUtils.round(5.0 * (parent.multiplyFactor / 100.0))
				}
				case "40": {
					return PowerUtils.round(6.0 * (parent.multiplyFactor / 100.0))
				}
			}
		}
		0.0
	}

	override describe(int indent) {
		if (isAllowed) {
			val result = new StringBuilder("\t".repeat(indent))
			result.append(" (Factor: ")
			result.append((eContainer as SARADC_12bit).multiplyFactor)
			result.append("%)\n")
			result.toString()
		} else {
			""
		}
	}

}
