package sr5e1_power.impl

import com.st.stellar.consumption.model.consumption.Cluster
import com.st.stellar.consumption.model.consumption.util.ConsumptionHelper
import sr5e1_power.ModulatorConfig
import sr5e1_power.SDADC

// This class overrides the generated class and will be instantiated by factory
class ModulatorConfigImpl extends MModulatorConfigImpl implements ModulatorConfig {
	new() {
		enabled = true
	}

	override getIDD_HV_IO() {
		0.0
	}

	override getIDD_HV() {
		0.0
	}

	override getIDD_HV_ADC() {
		0.0
	}

	override getIDD_LV() {
		if (isAllowed) {
			val Cluster cluster = ConsumptionHelper.getCluster(this)
			if(cluster === null) return 0.0
			val parent = eContainer as SDADC
			switch (parent.IP_CLK) {
				case "5": {
					return PowerUtils.round(1.0 * (parent.multiplyFactor / 100.0))
				}
				case "10": {
					return PowerUtils.round(2.0 * (parent.multiplyFactor / 100.0))
				}
				case "15": {
					return PowerUtils.round(3.0 * (parent.multiplyFactor / 100.0))
				}
			}
		}
		0.0
	}

	override describe(int indent) {
		if (isAllowed) {
			val result = new StringBuilder("\t".repeat(indent))
			result.append(" (Factor: ")
			result.append((eContainer as SDADC).multiplyFactor)
			result.append("%)\n")
			result.toString()
		} else {
			""
		}
	}

}
